/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.xdg.MenuDatabase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

class Menu {
    private String name;
    private Menu parent;
    private final ArrayList<Menu> subMenus = new ArrayList();
    private final ArrayList<String> entries = new ArrayList();

    Menu() {
    }

    Menu(Menu parent) {
        this();
        this.parent = parent;
        if (parent != null) {
            parent.addSubMenu(this);
        }
    }

    Menu(String name, Menu parent) {
        this(parent);
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    private String[] splitPath(String menuPath) {
        String remainder;
        String firstName;
        int slashIdx;
        int n = slashIdx = menuPath != null ? menuPath.indexOf(47) : -1;
        if (slashIdx >= 0) {
            firstName = menuPath.substring(0, slashIdx);
            remainder = menuPath.substring(slashIdx + 1, menuPath.length());
        } else {
            firstName = menuPath;
            remainder = null;
        }
        return new String[]{firstName, remainder};
    }

    Menu addMenuPath(String menuPath) {
        String[] split = this.splitPath(menuPath);
        String firstName = split[0];
        String remainder = split[1];
        Menu subMenu = this.getSubMenu(firstName);
        if (subMenu == null) {
            subMenu = new Menu(firstName, this);
        }
        if (remainder != null) {
            return subMenu.addMenuPath(remainder);
        }
        return subMenu;
    }

    Menu getMenuPath(String menuPath) {
        String[] split = this.splitPath(menuPath);
        String firstName = split[0];
        String remainder = split[1];
        Menu subMenu = this.getSubMenu(firstName);
        if (remainder != null && subMenu != null) {
            return subMenu.addMenuPath(remainder);
        }
        return subMenu;
    }

    Menu getSubMenu(String name) {
        if (name == null) {
            return null;
        }
        for (Menu menu : this.subMenus) {
            if (menu == null || menu.name == null || !menu.name.equals(name)) continue;
            return menu;
        }
        return null;
    }

    void addSubMenu(Menu subMenu) {
        if (subMenu != null && !this.subMenus.contains(subMenu)) {
            this.subMenus.add(subMenu);
        }
    }

    void removeSubMenu(Menu subMenu) {
        this.subMenus.remove(subMenu);
        this.cleanupEmptyMenus();
    }

    void addEntry(String entry) {
        if (entry != null) {
            this.entries.add(entry);
        }
    }

    void removeEntry(String entry) {
        this.entries.remove(entry);
        this.cleanupEmptyMenus();
    }

    private void cleanupEmptyMenus() {
        if (this.isEmpty() && this.parent != null && !MenuDatabase.isJavaWSMenu(this)) {
            this.parent.removeSubMenu(this);
        }
    }

    private boolean isEmpty() {
        return this.entries.isEmpty() && this.subMenus.isEmpty();
    }

    void write(Writer w) throws IOException {
        w.write("<Menu>\n");
        w.write("<Name>" + this.name + "</Name>\n");
        for (Menu subMenu : this.subMenus) {
            subMenu.write(w);
        }
        if (this.entries.size() > 0) {
            w.write("<Include>\n");
            for (String entry : this.entries) {
                w.write("<Filename>" + entry + "</Filename>\n");
            }
            w.write("</Include>\n");
        }
        w.write("</Menu>\n");
    }

    void read(XMLNode xml) {
        for (XMLNode nested = xml.getNested(); nested != null; nested = nested.getNext()) {
            if (nested.getName().equals("Menu")) {
                Menu menu = new Menu(this);
                menu.read(nested);
                this.addSubMenu(menu);
                continue;
            }
            if (nested.getName().equals("Name")) {
                XMLNode nameNode = nested.getNested();
                this.name = nameNode != null ? nameNode.getName() : "";
                continue;
            }
            if (!nested.getName().equals("Include")) continue;
            for (XMLNode fileNode = nested.getNested(); fileNode != null; fileNode = fileNode.getNext()) {
                XMLNode filenameNode = fileNode.getNested();
                this.addEntry(filenameNode.getName());
            }
        }
    }
}

