/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;

public class PackageDesc
implements ResourceType {
    private String _packageName;
    private String _part;
    private boolean _isRecursive;
    private boolean _isExact;

    public PackageDesc(String packageName, String part, boolean isRecursive) {
        if (packageName.endsWith(".*")) {
            this._packageName = packageName.substring(0, packageName.length() - 1);
            this._isExact = false;
        } else {
            this._isExact = true;
            this._packageName = packageName;
        }
        this._part = part;
        this._isRecursive = isRecursive;
    }

    String getPackageName() {
        return this._packageName;
    }

    String getPart() {
        return this._part;
    }

    boolean isRecursive() {
        return this._isRecursive;
    }

    boolean match(String name) {
        if (this._isExact) {
            return this._packageName.equals(name);
        }
        if (this._isRecursive) {
            return name.startsWith(this._packageName);
        }
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            name = name.substring(0, idx + 1);
        }
        return name.equals(this._packageName);
    }

    @Override
    public void visit(ResourceVisitor rv) {
        rv.visitPackageDesc(this);
    }

    public XMLNode asXML() {
        XMLAttributeBuilder ab = new XMLAttributeBuilder();
        ab.add("name", this.getPackageName());
        ab.add("part", this.getPart());
        ab.add("recursive", this.isRecursive());
        return new XMLNode("package", ab.getAttributeList());
    }
}

