/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.NativePlatform;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.ParameterUtil;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;

public class JREMatcher {
    private static final boolean DEBUG = Trace.isEnabled((TraceLevel)TraceLevel.RULESET);
    private JREDesc selectedJREDesc;
    private JREDesc runningJREDesc;
    private JREInfo selectedJREInfo;
    private boolean matchComplete;
    private boolean matchSecureComplete;
    private boolean matchVersion;
    private boolean matchJVMArgs;
    private boolean matchSecureJVMArgs;
    private long selectedMaxHeap;
    private long selectedInitHeap;
    private JVMParameters selectedJVMArgs;
    private JREDesc drsDesc;
    private boolean matchToJnlpFound;
    private boolean matchToDRSFound;
    private boolean secureOnly;

    public JREMatcher() {
        this.setDRSVersion(null, false);
    }

    public void setDRSVersion(String drsVersionString, boolean force) {
        this.drsDesc = drsVersionString != null ? new JREDesc(drsVersionString, force) : null;
        this.reset(null);
    }

    public boolean hasBeenRun() {
        return null != this.selectedJVMArgs;
    }

    public void beginTraversal(LaunchDesc ld) {
        this.reset(ld);
        if (DEBUG) {
            Trace.println((String)"\tMatch: beginTraversal");
        }
    }

    private void reset(LaunchDesc ld) {
        this.matchComplete = false;
        this.matchSecureComplete = false;
        this.matchVersion = false;
        this.matchJVMArgs = false;
        this.matchSecureJVMArgs = false;
        this.selectedInitHeap = -1L;
        this.selectedJREDesc = null;
        this.runningJREDesc = null;
        this.selectedJREInfo = null;
        if (null == ld) {
            this.selectedMaxHeap = -1L;
            this.selectedJVMArgs = null;
        } else {
            this.selectedMaxHeap = JVMParameters.getDefaultHeapSize();
            this.selectedJVMArgs = new JVMParameters();
        }
        this.matchToJnlpFound = false;
        this.matchToDRSFound = false;
    }

    public JREInfo getSelectedJREInfo() {
        return this.selectedJREInfo;
    }

    public JREDesc getSelectedJREDesc() {
        return this.selectedJREDesc;
    }

    public JREDesc getRunningJREDesc() {
        return this.runningJREDesc;
    }

    public void setRunningJREDesc(JREDesc running) {
        this.runningJREDesc = running;
    }

    public JVMParameters getSelectedJVMParameters() {
        return this.selectedJVMArgs;
    }

    public long getSelectedInitHeapSize() {
        return this.selectedInitHeap;
    }

    public long getSelectedMaxHeapSize() {
        return this.selectedMaxHeap;
    }

    public boolean isRunningJVMSatisfying(boolean includeInsecure) {
        String ver;
        if (this.secureOnly && !SecurityBaseline.satisfiesSecurityBaseline((String)(ver = System.getProperty("java.version")))) {
            return false;
        }
        if (this.selectedJREInfo != null && !this.hasRunningVMRequiredArgs(this.selectedJREInfo)) {
            return false;
        }
        if (includeInsecure) {
            return this.matchComplete;
        }
        return this.matchSecureComplete;
    }

    private boolean hasRunningVMRequiredArgs(JREInfo jreInfo) {
        return ParameterUtil.hasRunningVMRequiredArgs((String)jreInfo.getVmArgs());
    }

    public boolean isRunningJVMVersionSatisfying() {
        return this.matchVersion;
    }

    public boolean isRunningJVMArgsSatisfying(boolean includeInsecure) {
        if (includeInsecure) {
            return this.matchJVMArgs;
        }
        return this.matchSecureJVMArgs;
    }

    public void digest(JREDesc jd, JREInfo ji) {
        if (DEBUG) {
            Trace.println((String)("Match: digest selected JREDesc: " + jd + ", JREInfo: " + ji));
        }
        this.selectedJREDesc = jd;
        this.selectedJREInfo = ji;
        long heapSize = jd.getMaxHeap();
        if (heapSize > this.selectedMaxHeap) {
            this.selectedMaxHeap = heapSize;
            if (DEBUG) {
                Trace.println((String)("\tMatch: selecting maxHeap: " + heapSize));
            }
        } else if (DEBUG) {
            Trace.println((String)("\tMatch: ignoring maxHeap: " + heapSize));
        }
        if ((heapSize = jd.getMinHeap()) > this.selectedInitHeap) {
            this.selectedInitHeap = heapSize;
            if (DEBUG) {
                Trace.println((String)("\tMatch: selecting InitHeap: " + heapSize));
            }
        } else if (DEBUG) {
            Trace.println((String)("\tMatch: ignoring InitHeap: " + heapSize));
        }
        if (DEBUG) {
            Trace.println((String)("\tMatch: digesting vmargs: " + jd.getVmArgs()));
        }
        this.selectedJVMArgs.parse(jd.getVmArgs());
        if (DEBUG) {
            Trace.println((String)("\tMatch: digested vmargs: " + this.selectedJVMArgs));
        }
        if ((heapSize = this.selectedJVMArgs.getMaxHeapSize()) > this.selectedMaxHeap) {
            this.selectedMaxHeap = heapSize;
            if (DEBUG) {
                Trace.println((String)("\tMatch: selecting maxHeap(2): " + heapSize));
            }
        }
        this.selectedJVMArgs.setMaxHeapSize(JVMParameters.getDefaultHeapSize());
        if (DEBUG) {
            Trace.println((String)("\tMatch: JVM args after accumulation: " + this.selectedJVMArgs));
        }
        if (ji == null && this.drsDesc != null) {
            this.calculateMatchesToDRS();
        }
    }

    private void calculateMatchesToDRS() {
        JREInfo[] jres = JREInfo.getValidSorted();
        if (jres != null) {
            for (int i = 0; i < jres.length; ++i) {
                if (!JREMatcher.isDRSVersionMatch(jres[i], this.drsDesc)) continue;
                this.matchToDRSFound = true;
            }
        }
    }

    public static String getJREVersionFromDRS(DeploymentRuleSet drs) {
        JREDesc drsJREDesc = new JREDesc(drs.getVersionString(), drs.isVersionForced());
        JREInfo[] jres = JREInfo.getValidSorted();
        if (jres != null) {
            for (int i = 0; i < jres.length; ++i) {
                if (!JREMatcher.isDRSVersionMatch(jres[i], drsJREDesc)) continue;
                return jres[i].getProduct();
            }
        }
        return null;
    }

    public void digest(ResourcesDesc rd) {
        if (rd != null) {
            this.selectedJVMArgs.addProperties(rd.getResourcePropertyList());
            if (DEBUG) {
                LaunchDesc ld = rd.getParent();
                if (ld != null) {
                    Trace.println((String)("\tMatch: digest LaunchDesc: " + ld.getLocation()));
                }
                Trace.println((String)("\tMatch: digest properties: " + rd.getResourcePropertyList()));
                Trace.println((String)("\tMatch: JVM args: " + this.selectedJVMArgs));
            }
        }
    }

    public void endTraversal(LaunchDesc ld) {
        if (DEBUG) {
            Trace.println((String)"\tMatch: endTraversal ..");
        }
        if (ld.isApplicationDescriptor() && null == this.selectedJREDesc) {
            throw new IllegalArgumentException("selectedJREDesc null");
        }
        if (this.selectedInitHeap > 0L && this.selectedInitHeap != JVMParameters.getDefaultHeapSize()) {
            this.selectedJVMArgs.parse("-Xms" + JVMParameters.unparseMemorySpec((long)this.selectedInitHeap));
        }
        this.selectedJVMArgs.setMaxHeapSize(this.selectedMaxHeap);
        if (this.selectedJREInfo == null) {
            return;
        }
        this.matchVersion = this.isVersionMatch(ld, this.selectedJREInfo);
        JVMParameters runningJVMParams = JVMParameters.getRunningJVMParameters();
        if (runningJVMParams == null) {
            if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("\t Match: Running JVM is not set: want:<" + this.selectedJVMArgs + ">"), (TraceLevel)TraceLevel.BASIC);
            }
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = false;
        } else if (runningJVMParams.satisfies(this.selectedJVMArgs)) {
            if (DEBUG) {
                Trace.println((String)("\t Match: Running JVM args match: have:<" + runningJVMParams + ">  satisfy want:<" + this.selectedJVMArgs + ">"));
            }
            this.matchJVMArgs = true;
            this.matchSecureJVMArgs = true;
        } else if (runningJVMParams.satisfiesSecure(this.selectedJVMArgs)) {
            if (DEBUG) {
                Trace.println((String)("\t Match: Running JVM args match the secure subset: have:<" + runningJVMParams + ">  satisfy want:<" + this.selectedJVMArgs + ">"));
            }
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = true;
        } else {
            if (DEBUG) {
                Trace.println((String)("\t Match: Running JVM args mismatch: have:<" + runningJVMParams + "> !satisfy want:<" + this.selectedJVMArgs + ">"));
            }
            this.matchJVMArgs = false;
            this.matchSecureJVMArgs = false;
        }
        this.matchComplete = this.matchVersion && this.matchJVMArgs;
        this.matchSecureComplete = this.matchVersion && this.matchSecureJVMArgs;
    }

    private static boolean isPlatformMatch(JREInfo jre, JREDesc desc) {
        VersionString vs = new VersionString(desc.getVersion());
        return JREMatcher.isArchMatch(jre, desc) && vs.contains(jre.getPlatform());
    }

    private static boolean isProductMatch(JREInfo jre, JREDesc desc, boolean ignoreDash) {
        boolean sameLocation;
        String product = jre.getProduct();
        if (ignoreDash) {
            int index = product.indexOf("-");
            product = index > 0 ? product.substring(0, index) : product;
        }
        VersionString vs = new VersionString(desc.getVersion());
        URL location = desc.getHref();
        boolean bl = sameLocation = location == null || jre.getLocation().equals(location.toString());
        if (sameLocation) {
            return JREMatcher.isArchMatch(jre, desc) && vs.contains(product);
        }
        return false;
    }

    private static boolean isArchMatch(JREInfo jre, JREDesc desc) {
        String[] arches = desc.getArchList();
        if (arches == null) {
            return true;
        }
        for (String arch : arches) {
            NativePlatform np = new NativePlatform(null, arch);
            if (!jre.getNativePlatform().match(np)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDefaultVersionMatch(JREInfo info, JREDesc desc) {
        if (this.secureOnly) {
            return SecurityBaseline.satisfiesSecurityBaseline((String)info.getProduct());
        }
        if (desc.getVersionType() == 0) {
            return JREMatcher.isProductMatch(info, desc, false);
        }
        return JREMatcher.isPlatformMatch(info, desc);
    }

    public boolean isVersionMatch(JREInfo info, JREDesc desc) {
        if (!info.isFakeJRE() && !new File(info.getPath()).exists()) {
            return false;
        }
        if (this.drsDesc != null && this.drsDesc.isVersionForced()) {
            if (JREMatcher.isDRSVersionMatch(info, this.drsDesc)) {
                this.matchToJnlpFound = true;
                return true;
            }
            return false;
        }
        if (!this.isDefaultVersionMatch(info, desc)) {
            return false;
        }
        if (this.drsDesc != null) {
            this.matchToJnlpFound = true;
            return JREMatcher.isDRSVersionMatch(info, this.drsDesc);
        }
        return true;
    }

    private static boolean isDRSVersionMatch(JREInfo info, JREDesc drsDesc) {
        if (drsDesc.isSecure()) {
            VersionString vs;
            if (drsDesc.getVersion() == null) {
                return SecurityBaseline.satisfiesBaselineStrictly((String)info.getProduct());
            }
            String ver = drsDesc.getVersion();
            if (ver.endsWith("+") ? !(vs = new VersionString(ver)).contains(info.getProduct()) : !info.getProduct().startsWith(ver)) {
                return false;
            }
            return SecurityBaseline.satisfiesBaselineStrictly((String)info.getProduct());
        }
        if (drsDesc.getVersionType() == 0) {
            return JREMatcher.isProductMatch(info, drsDesc, true);
        }
        return JREMatcher.isPlatformMatch(info, drsDesc);
    }

    public boolean isVersionMatch(LaunchDesc ld, JREInfo selected) {
        if (this.secureOnly) {
            return SecurityBaseline.satisfiesSecurityBaseline((String)selected.getProduct());
        }
        if (!selected.isArchMatch()) {
            Trace.println((String)"Selected other architecture", (TraceLevel)TraceLevel.BASIC);
            return false;
        }
        JREInfo homeJREInfo = ld.getHomeJRE();
        if (!homeJREInfo.getProductVersion().match(selected.getProductVersion())) {
            if (DEBUG) {
                Trace.println((String)("\tMatch: Running JREInfo Version mismatches: " + homeJREInfo.getProductVersion() + " != " + selected.getProductVersion()));
            }
            return false;
        }
        if (DEBUG) {
            Trace.println((String)("\tMatch: Running JREInfo Version    match: " + homeJREInfo.getProductVersion() + " == " + selected.getProductVersion()));
        }
        return true;
    }

    public void setSecureOnly(boolean secureOnly) {
        if (this.secureOnly != secureOnly) {
            this.reset(null);
            this.secureOnly = secureOnly;
        }
    }

    public boolean getSecureOnly() {
        return this.secureOnly;
    }

    public String toString() {
        return "JREMatcher: \n  JREDesc:    " + this.getSelectedJREDesc() + "\n  JREInfo:    " + this.getSelectedJREInfo() + "\n  Init Heap:  " + this.getSelectedInitHeapSize() + "\n  Max  Heap:  " + this.getSelectedMaxHeapSize() + "\n  Satisfying: " + this.isRunningJVMSatisfying(true) + ", " + this.isRunningJVMSatisfying(false) + "\n  SatisfyingVersion: " + this.isRunningJVMVersionSatisfying() + "\n  SatisfyingJVMArgs: " + this.isRunningJVMArgsSatisfying(true) + ", " + this.isRunningJVMSatisfying(false) + "\n  SatisfyingSecure: " + this.isRunningJVMSatisfying(true) + "\n  Selected JVMParam: " + this.getSelectedJVMParameters() + "\n  Running  JVMParam: " + JVMParameters.getRunningJVMParameters();
    }
}

