/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.wizard;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.console.ui.notification.NotificationPlugin;
import com.oracle.jmc.console.ui.notification.widget.ConditionChooser;
import com.oracle.jmc.console.ui.notification.wizard.Messages;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.triggers.ITrigger;
import com.oracle.jmc.rjmx.triggers.IValueEvaluator;
import com.oracle.jmc.rjmx.triggers.TriggerRule;
import com.oracle.jmc.rjmx.triggers.condition.internal.TriggerCondition;
import com.oracle.jmc.rjmx.triggers.fields.internal.Field;
import com.oracle.jmc.rjmx.triggers.fields.internal.QuantityField;
import com.oracle.jmc.rjmx.triggers.internal.NotificationRegistry;
import com.oracle.jmc.rjmx.triggers.internal.ValueEvaluatorNumberMax;
import com.oracle.jmc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import com.oracle.jmc.rjmx.ui.internal.AttributeSelectionContentModel;
import com.oracle.jmc.rjmx.ui.internal.IAttributeSelectionContentListener;
import com.oracle.jmc.ui.uibuilder.IUIBuilder;
import com.oracle.jmc.ui.uibuilder.StandardUIBuilder;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TriggerConditionWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "com.oracle.jmc.notification.trigger.condition";
    private final AttributeSelectionContentModel m_selectorModel;
    private final NotificationRegistry m_notificationModel;
    private final TriggerRule m_notificationRule;
    private final IConnectionHandle m_connectionHandle;
    private ConditionChooser m_conditionChooser;

    public TriggerConditionWizardPage(AttributeSelectionContentModel selectorModel, NotificationRegistry model, IConnectionHandle connectionHandle, TriggerRule notificationRule) {
        super(PAGE_NAME, Messages.TriggerConditionWizardPage_TITLE, null);
        this.setDescription(Messages.TriggerConditionWizardPage_DESCRIPTION);
        this.m_selectorModel = selectorModel;
        this.m_notificationModel = model;
        this.m_notificationRule = notificationRule;
        this.m_connectionHandle = connectionHandle;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        StandardUIBuilder suib = new StandardUIBuilder(control);
        if (this.m_notificationRule.getTrigger() instanceof TriggerCondition) {
            this.m_conditionChooser = new ConditionChooser(false, (IUIBuilder)suib, this.m_notificationRule, this.m_notificationModel, this.m_connectionHandle, control);
            this.m_conditionChooser.select((ITrigger)this.m_notificationRule.getTrigger());
            this.m_selectorModel.addListener(new IAttributeSelectionContentListener(){

                public void selectionChanged(AttributeSelectionContentModel selectorModel) {
                    final MRI[] selectedAttributes = selectorModel.getSelectedAttributes();
                    if (selectedAttributes.length > 0) {
                        final IUnit unit = selectorModel.getAttributeUnit(selectedAttributes[0]);
                        final TriggerCondition trigger = (TriggerCondition)TriggerConditionWizardPage.this.m_notificationRule.getTrigger();
                        TriggerConditionWizardPage.this.m_notificationModel.performCriticalRuleChange(TriggerConditionWizardPage.this.m_notificationRule, new Runnable(){

                            @Override
                            public void run() {
                                TriggerConditionWizardPage.this.m_notificationRule.getTrigger().setAttributeDescriptor(selectedAttributes[0]);
                                if (unit != null) {
                                    IQuantity zeroQuantity = unit.quantity(0L);
                                    trigger.setValueEvaluator((IValueEvaluator)new ValueEvaluatorNumberMax(zeroQuantity));
                                    Field field = trigger.getFieldHolder().getField("EVAL_NUM_MAX");
                                    if (field instanceof QuantityField) {
                                        ((QuantityField)field).initKind(unit.getContentType(), zeroQuantity.interactiveFormat(), null, null);
                                    }
                                    field.setValue(zeroQuantity.interactiveFormat());
                                } else {
                                    trigger.setValueEvaluator((IValueEvaluator)new ValueEvaluatorStringMatch("*"));
                                }
                            }
                        });
                    }
                }
            });
        } else {
            NotificationPlugin.getDefault().getLogger().severe("Create control: wrong type!");
        }
        this.setControl((Control)control);
    }

    public void setVisible(boolean visble) {
        super.setVisible(visble);
        if (this.m_notificationRule.getTrigger() instanceof TriggerCondition) {
            this.m_conditionChooser.select((ITrigger)this.m_notificationRule.getTrigger());
        } else {
            NotificationPlugin.getDefault().getLogger().severe("Set visible: wrong type!");
        }
    }
}

