/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.uicomponents;

import com.oracle.jmc.console.ui.notification.uicomponents.BooleanInputItem;
import com.oracle.jmc.console.ui.notification.uicomponents.FileInputItem;
import com.oracle.jmc.console.ui.notification.uicomponents.InputItem;
import com.oracle.jmc.console.ui.notification.uicomponents.PasswordInputItem;
import com.oracle.jmc.console.ui.notification.uicomponents.QuantityInputItem;
import com.oracle.jmc.console.ui.notification.uicomponents.TextInputItem;
import com.oracle.jmc.rjmx.triggers.fields.internal.Field;
import com.oracle.jmc.rjmx.triggers.fields.internal.FieldHolder;
import com.oracle.jmc.rjmx.triggers.fields.internal.PasswordField;
import com.oracle.jmc.ui.uibuilder.IUIBuilder;

public class FieldRenderer {
    private final FieldHolder m_fieldHolder;
    private final IUIBuilder m_builder;

    public FieldRenderer(FieldHolder fieldHolder, IUIBuilder builder) {
        this.m_fieldHolder = fieldHolder;
        this.m_builder = builder;
    }

    protected FieldHolder getFieldHolder() {
        return this.m_fieldHolder;
    }

    protected IUIBuilder getBuilder() {
        return this.m_builder;
    }

    public void render() {
        Field[] fields;
        Field[] fieldArray = fields = this.getFieldHolder().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            this.createInputItem(field);
            ++n2;
        }
    }

    protected InputItem createInputItem(Field field) {
        switch (field.getType()) {
            case 1: 
            case 2: 
            case 8: 
            case 16: 
            case 32: {
                return new TextInputItem(field, this.getBuilder());
            }
            case 256: {
                return new QuantityInputItem(field, this.getBuilder());
            }
            case 64: {
                return new BooleanInputItem(field, this.getBuilder());
            }
            case 4: {
                return new FileInputItem(field, this.getBuilder());
            }
            case 128: {
                return new PasswordInputItem((PasswordField)field, this.getBuilder());
            }
        }
        return null;
    }
}

