/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.tab;

import com.oracle.jmc.alert.AlertPlugin;
import com.oracle.jmc.console.ui.actions.MBeanAutomaticRefreshAction;
import com.oracle.jmc.console.ui.notification.NotificationPlugin;
import com.oracle.jmc.console.ui.notification.tab.Messages;
import com.oracle.jmc.console.ui.notification.tab.RuleCheckedStateProvider;
import com.oracle.jmc.console.ui.notification.tab.RuleGroup;
import com.oracle.jmc.console.ui.notification.tab.TriggerContentProvider;
import com.oracle.jmc.console.ui.notification.tab.TriggerLabelProvider;
import com.oracle.jmc.console.ui.notification.tab.TriggerToolkit;
import com.oracle.jmc.console.ui.notification.wizard.RuleExportWizard;
import com.oracle.jmc.console.ui.notification.wizard.RuleImportWizard;
import com.oracle.jmc.console.ui.notification.wizard.RuleWizardDialog;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.subscription.IMBeanHelperService;
import com.oracle.jmc.rjmx.subscription.IMBeanServerChangeListener;
import com.oracle.jmc.rjmx.subscription.IMRIService;
import com.oracle.jmc.rjmx.triggers.TriggerRule;
import com.oracle.jmc.rjmx.triggers.internal.NotificationRegistry;
import com.oracle.jmc.ui.misc.DialogToolkit;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.misc.IRefreshable;
import com.oracle.jmc.ui.misc.MCSectionPart;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TriggerSectionPart
extends MCSectionPart {
    private Button m_addButton;
    private Button m_deleteButton;
    private CheckboxTreeViewer m_viewer;
    private Button m_exportButton;
    private Button m_importButton;
    private Button m_renameButton;
    private Button m_resetButton;
    private static final int MAX_REMOVE_TRIGGERS_TO_DISPLAY = 5;
    private final IConnectionHandle connection;
    private final IRefreshable refresher = new IRefreshable(){

        public boolean refresh() {
            DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!TriggerSectionPart.this.m_viewer.getControl().isDisposed()) {
                        TriggerSectionPart.this.m_viewer.refresh();
                    }
                }
            });
            return false;
        }
    };
    private final MBeanAutomaticRefreshAction refreshAction = new MBeanAutomaticRefreshAction(this.refresher);
    private final NotificationRegistry model;

    public TriggerSectionPart(Composite parent, FormToolkit toolkit, NotificationRegistry model, IConnectionHandle connection) {
        super(parent, toolkit, 384);
        this.model = model;
        this.connection = connection;
        this.getSection().setText(Messages.TriggerSectionPart_SECTION_TEXT);
        this.getSection().setDescription(Messages.TriggerSectionPart_SECTION_DESCRIPTION);
        this.createClient(toolkit);
        this.setupRefreshAction();
        this.setupExpansionStateHandling();
    }

    public void dispose() {
        super.dispose();
        ((IMBeanHelperService)this.connection.getServiceOrDummy(IMBeanHelperService.class)).removeMBeanServerChangeListener((IMBeanServerChangeListener)this.refreshAction);
    }

    private Object getFirstSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        return selection.getFirstElement();
    }

    private void selectRule(TriggerRule rule) {
        StructuredSelection s = new StructuredSelection(new Object[]{rule});
        this.m_viewer.setSelection((ISelection)s, true);
    }

    private void createClient(FormToolkit toolkit) {
        Section section = this.getSection();
        Composite client = toolkit.createComposite((Composite)section, 64);
        Color bgColor = section.getBackground();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        GridData gd = null;
        Tree tree = toolkit.createTree(client, 32);
        tree.setData("name", (Object)"triggers.RulesTree");
        gd = new GridData(4, 4, true, true);
        this.m_viewer = this.createViewer(toolkit, tree, client);
        tree.setLayoutData((Object)gd);
        gd = new GridData(4, 1, false, false);
        Composite buttons = this.createButtons(toolkit, client);
        buttons.setBackground(bgColor);
        buttons.setLayoutData((Object)gd);
        client.setBackground(bgColor);
        client.setLayout((Layout)layout);
        bgColor.dispose();
        section.setClient((Control)client);
    }

    private Composite createButtons(FormToolkit toolkit, Composite client) {
        Composite buttonContainer = toolkit.createComposite(client, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData gd1 = new GridData(4, 1, false, false);
        this.m_addButton = this.createAddButton(toolkit, buttonContainer);
        this.m_addButton.setLayoutData((Object)gd1);
        GridData gd3 = new GridData(4, 1, false, false);
        this.m_renameButton = this.createRenameButton(toolkit, buttonContainer);
        this.m_renameButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 1, false, false);
        this.m_deleteButton = this.createDeleteButton(toolkit, buttonContainer);
        this.m_deleteButton.setLayoutData((Object)gd4);
        GridData gd6 = new GridData(4, 1, false, false);
        gd6.verticalIndent = 10;
        this.m_importButton = this.createImport(toolkit, buttonContainer);
        this.m_importButton.setLayoutData((Object)gd6);
        GridData gd7 = new GridData(4, 1, false, false);
        this.m_exportButton = this.createExport(toolkit, buttonContainer);
        this.m_exportButton.setLayoutData((Object)gd7);
        GridData gd8 = new GridData(4, 1, false, false);
        this.m_resetButton = this.createReset(toolkit, buttonContainer);
        this.m_resetButton.setLayoutData((Object)gd8);
        GridData gd9 = new GridData(4, 1, false, false);
        gd9.verticalIndent = 10;
        Button showAlertButton = this.createShowAlertButton(toolkit, buttonContainer);
        showAlertButton.setLayoutData((Object)gd9);
        buttonContainer.setLayout((Layout)layout);
        this.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = TriggerSectionPart.this.getFirstSelected();
                boolean enableButtons = selected instanceof TriggerRule || selected instanceof RuleGroup;
                TriggerSectionPart.this.m_deleteButton.setEnabled(enableButtons);
                TriggerSectionPart.this.m_renameButton.setEnabled(enableButtons);
            }
        });
        return buttonContainer;
    }

    private Button createReset(FormToolkit toolkit, Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_TRIGGERS_RESET_BUTTON_TEXT, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DialogToolkit.openQuestionOnUiThread((String)Messages.TriggerSectionPart_RESET_TITLE_TEXT, (String)Messages.TriggerSectionPart_RESET_TO_DEFAULT_QUESTION_TEXT)) {
                    IStatus status = TriggerToolkit.resetTriggers(TriggerSectionPart.this.model);
                    if (status.getSeverity() != 0) {
                        ErrorDialog.openError((Shell)TriggerSectionPart.this.getSection().getShell(), (String)Messages.TriggerSectionPart_ERROR_MESSAGE_RESETTING_TRIGGERS, null, (IStatus)status);
                    }
                    TriggerSectionPart.this.updateTree();
                }
            }
        });
        return button;
    }

    private void updateTree() {
        this.m_viewer.refresh();
        this.m_exportButton.setEnabled(this.m_viewer.getTree().getItemCount() > 0);
    }

    private void addNewRule() {
        RuleWizardDialog rwd;
        Display display = Display.getCurrent();
        if (display.isDisposed()) {
            return;
        }
        Shell shell = display.getActiveShell();
        if (shell == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        String ruleGroupName = Messages.TriggerSectionPart_DEFAULT_RULES_GROUP_NAME_TEXT;
        if (!selection.isEmpty()) {
            Object object = selection.iterator().next();
            if (object instanceof RuleGroup) {
                ruleGroupName = ((RuleGroup)object).getName();
            }
            if (object instanceof TriggerRule) {
                ruleGroupName = ((TriggerRule)object).getRulePath();
            }
        }
        if ((rwd = new RuleWizardDialog(shell, null, this.connection, ruleGroupName, this.model)).open() != 0) {
            return;
        }
        TriggerRule rule = rwd.getNewRule();
        this.model.addNotificationRule(rule);
        this.updateTree();
        this.selectRule(rule);
    }

    private void rename(RuleGroup group) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.TriggerSectionPart_RENAME_RULE_GROUP_TITLE, Messages.TriggerSectionPart_ENTER_NEW_GROUP_NAME_TEXT, group.getName(), null);
        if (dialog.open() == 0) {
            String newName = dialog.getValue();
            for (TriggerRule rule : group.getRules()) {
                rule.setRulePath(newName);
            }
        }
        this.updateTree();
    }

    private void rename(final TriggerRule rule) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.TriggerSectionPart_DIALOG_RENAME_RULE_TITLE, Messages.TriggerSectionPart_DIALOG_RENAME_RULE_MESSAGE_TEXT, rule.getName(), new IInputValidator(){

            public String isValid(String newText) {
                for (TriggerRule aRule : TriggerSectionPart.this.model.getAvailableRules()) {
                    if (!aRule.getName().equals(newText) || aRule == rule) continue;
                    return Messages.TriggerSectionPart_DIALOG_RULE_EXISTS_MESSAGE_TEXT;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String newName = dialog.getValue();
            if (!rule.getName().equals(newName)) {
                rule.setName(newName);
            }
        }
        this.m_viewer.refresh();
    }

    private Button createShowAlertButton(FormToolkit toolkit, Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_SHOW_ALERTS_TEXT0, 0);
        button.setImage(NotificationPlugin.getDefault().getImage("alert_obj.png"));
        button.addSelectionListener((SelectionListener)new ShowAlertsButtonSelectionListener());
        return button;
    }

    private Button createAddButton(FormToolkit toolkit, Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_ADD_TEXT, 8);
        button.setToolTipText(Messages.TriggerSectionPart_BUTTON_ADD_TOOLTIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TriggerSectionPart.this.addNewRule();
            }
        });
        return button;
    }

    private Button createImport(FormToolkit toolkit, final Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_IMPORT_TRIGGERS_BUTTON_TEXT, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TriggerSectionPart.this.showWizardPage(buttonContainer.getShell(), (IWorkbenchWizard)new RuleImportWizard());
                TriggerSectionPart.this.updateTree();
            }
        });
        return button;
    }

    private Button createExport(FormToolkit toolkit, final Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_EXPORT_TRIGGER_BUTTON_TEXT_NAME, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TriggerSectionPart.this.showWizardPage(buttonContainer.getShell(), (IWorkbenchWizard)new RuleExportWizard());
            }
        });
        return button;
    }

    private void showWizardPage(Shell shell, IWorkbenchWizard wizard) {
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)this.m_viewer.getSelection());
        WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
        wd.open();
    }

    private Button createRenameButton(FormToolkit toolkit, Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_RENAME_TEXT, 8);
        button.setToolTipText(Messages.TriggerSectionPart_TOOLTIP_RENAME_RULE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = TriggerSectionPart.this.getFirstSelected();
                if (selected instanceof TriggerRule) {
                    TriggerSectionPart.this.rename((TriggerRule)selected);
                }
                if (selected instanceof RuleGroup) {
                    TriggerSectionPart.this.rename((RuleGroup)selected);
                }
            }
        });
        return button;
    }

    private boolean askConfirmation(Shell shell, TriggerRule ... rules) {
        LinkedList<String> names = new LinkedList<String>();
        TriggerRule[] triggerRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerRule rule = triggerRuleArray[n2];
            names.add(rule.getName());
            ++n2;
        }
        Collections.sort(names);
        StringBuilder namesBuilder = new StringBuilder();
        int index = 0;
        for (String name : names) {
            if (index < 5) {
                namesBuilder.append("\n");
                namesBuilder.append(name);
            } else if (index == 5) {
                namesBuilder.append("\n...");
                break;
            }
            ++index;
        }
        String messageText = NLS.bind((String)Messages.TriggerSectionPart_CONFIRM_REMOVE_TRIGGER_SINGULAR, (Object)namesBuilder.toString());
        if (names.size() > 1) {
            messageText = NLS.bind((String)Messages.TriggerSectionPart_CONFIRM_REMOVE_TRIGGER_PLURAL, (Object)names.size(), (Object)namesBuilder.toString());
        }
        return MessageDialog.openConfirm((Shell)shell, (String)Messages.TriggerSectionPart_CONFIRM_REMOVE_TITLE, (String)messageText);
    }

    private void askConfirmationAndDelete(Shell shell, TriggerRule ... rules) {
        if (rules.length > 0 && this.askConfirmation(shell, rules)) {
            TriggerRule[] triggerRuleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerRule rule = triggerRuleArray[n2];
                this.model.removeNotificationRule(rule);
                ++n2;
            }
        }
    }

    private Button createDeleteButton(FormToolkit toolkit, final Composite buttonContainer) {
        Button button = toolkit.createButton(buttonContainer, Messages.TriggerSectionPart_BUTTON_DELETE_TEXT, 8);
        button.setToolTipText(Messages.TriggerSectionPart_BUTTON_DELETE_TOOLTIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = TriggerSectionPart.this.getFirstSelected();
                if (selected instanceof TriggerRule) {
                    TriggerSectionPart.this.askConfirmationAndDelete(buttonContainer.getShell(), new TriggerRule[]{(TriggerRule)selected});
                } else if (selected instanceof RuleGroup) {
                    List<TriggerRule> rules = ((RuleGroup)selected).getRules();
                    TriggerSectionPart.this.askConfirmationAndDelete(buttonContainer.getShell(), rules.toArray(new TriggerRule[rules.size()]));
                }
                TriggerSectionPart.this.updateTree();
            }
        });
        return button;
    }

    private void setupRefreshAction() {
        ((IMBeanHelperService)this.connection.getServiceOrDummy(IMBeanHelperService.class)).addMBeanServerChangeListener((IMBeanServerChangeListener)this.refreshAction);
        this.getMCToolBarManager().add((IAction)this.refreshAction);
    }

    private String getServerGuid() {
        return this.connection.getServerDescriptor().getGUID();
    }

    private void setupExpansionStateHandling() {
        TriggerToolkit.retrieveExpansionState((TreeViewer)this.m_viewer, this.model);
        TriggerToolkit.storeExpansionState((TreeViewer)this.m_viewer);
        this.m_viewer.getTree().getParent().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TriggerToolkit.storeExpansionState((TreeViewer)TriggerSectionPart.this.m_viewer);
            }
        });
    }

    private CheckboxTreeViewer createViewer(FormToolkit toolkit, Tree tree, Composite client) {
        IMRIService mriService = (IMRIService)this.connection.getServiceOrNull(IMRIService.class);
        RuleCheckedStateProvider ruleStateProvider = new RuleCheckedStateProvider(mriService, this.getServerGuid(), this.model);
        ContainerCheckedTreeViewer viewer = new ContainerCheckedTreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new TriggerContentProvider(this.model));
        viewer.setComparator(new ViewerComparator());
        viewer.setLabelProvider((IBaseLabelProvider)new TriggerLabelProvider(ruleStateProvider));
        viewer.setInput((Object)this.model);
        viewer.setCheckStateProvider((ICheckStateProvider)ruleStateProvider);
        viewer.addCheckStateListener((ICheckStateListener)ruleStateProvider);
        return viewer;
    }

    public void addSelectionListener(ISelectionChangedListener l) {
        this.m_viewer.addSelectionChangedListener(l);
    }

    public IRefreshable getRefresher() {
        return this.refresher;
    }

    private static class ShowAlertsButtonSelectionListener
    extends SelectionAdapter {
        private ShowAlertsButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AlertPlugin.getDefault().showDialog(true);
        }
    }
}

