/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.tab;

import com.oracle.jmc.console.ui.notification.tab.ActionComponentFactory;
import com.oracle.jmc.console.ui.notification.tab.Messages;
import com.oracle.jmc.console.ui.notification.tab.TriggerConditionSectionPart;
import com.oracle.jmc.console.ui.notification.widget.ActionChooser;
import com.oracle.jmc.console.ui.notification.widget.ConstraintChooser;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.triggers.TriggerRule;
import com.oracle.jmc.rjmx.triggers.internal.NotificationRegistry;
import com.oracle.jmc.ui.misc.CompositeToolkit;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.misc.IRefreshable;
import com.oracle.jmc.ui.uibuilder.FormToolkitBuilder;
import com.oracle.jmc.ui.uibuilder.IUIBuilder;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TriggerDetailsPage {
    private final NotificationRegistry model;
    private final IConnectionHandle connection;
    private final IRefreshable onUpdateCallback;
    private final FormToolkit toolkit;
    private final CTabItem conditionsTab;
    private final CTabItem actionsTab;
    private final CTabItem constranitTab;

    public TriggerDetailsPage(Composite parent, NotificationRegistry model, IConnectionHandle connection, IRefreshable onUpdateCallback, FormToolkit toolkit) {
        this.model = model;
        this.connection = connection;
        this.onUpdateCallback = onUpdateCallback;
        this.toolkit = toolkit;
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.RuleDetailsTabSectionPart_SECTION_TEXT);
        CTabFolder tabFolder = new CTabFolder((Composite)section, 0);
        toolkit.adapt((Composite)tabFolder);
        section.setClient((Control)tabFolder);
        this.conditionsTab = TriggerDetailsPage.createTab(tabFolder, Messages.RuleDetailsTabSectionPart_CONDITION_TAB_TEXT);
        this.actionsTab = TriggerDetailsPage.createTab(tabFolder, Messages.RuleDetailsTabSectionPart_ACTION_TAB_TEXT);
        this.constranitTab = TriggerDetailsPage.createTab(tabFolder, Messages.RuleDetailsTabSectionPart_CONSTRAINTS_TAB_TEXT);
        tabFolder.setSelection(0);
    }

    public void showRule(TriggerRule rule) {
        Composite cond = this.createTabContainer(this.conditionsTab);
        new TriggerConditionSectionPart(cond, this.toolkit, this.model, rule, this.connection);
        TriggerDetailsPage.setAsTabContent(cond, this.conditionsTab);
        Composite actions = this.createTabContainer(this.actionsTab);
        FormToolkitBuilder ab = new FormToolkitBuilder(this.toolkit, actions);
        ActionComponentFactory factory = new ActionComponentFactory(this.toolkit, this.connection);
        ActionChooser chooser = new ActionChooser((IUIBuilder)ab, rule, this.connection, this.model, actions, true, true, true, factory);
        chooser.createAndAddActionSelectionChangedListener(this.onUpdateCallback);
        TriggerDetailsPage.setAsTabContent(actions, this.actionsTab);
        Composite constr = this.createTabContainer(this.constranitTab);
        FormToolkitBuilder constraintsBuilder = new FormToolkitBuilder(this.toolkit, constr);
        new ConstraintChooser((IUIBuilder)constraintsBuilder, rule, this.model, constr, false, false);
        TriggerDetailsPage.setAsTabContent(constr, this.constranitTab);
    }

    private Composite createTabContainer(CTabItem tab) {
        ScrolledComposite scrolled = CompositeToolkit.createVerticalScrollComposite((Composite)tab.getParent());
        Composite client = this.toolkit.createComposite((Composite)scrolled);
        scrolled.setContent((Control)client);
        client.setLayout((Layout)new GridLayout());
        this.toolkit.paintBordersFor(client);
        return client;
    }

    private static void setAsTabContent(Composite tabContainer, CTabItem tab) {
        Control oldControl = tab.getControl();
        tab.setControl((Control)tabContainer.getParent());
        DisplayToolkit.dispose((Widget)oldControl);
    }

    private static CTabItem createTab(CTabFolder tabFolder, String text) {
        CTabItem tab = new CTabItem(tabFolder, 0);
        tab.setText(text);
        return tab;
    }
}

