/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.tab;

import com.oracle.jmc.console.ui.notification.tab.Messages;
import com.oracle.jmc.console.ui.notification.widget.ConditionChooser;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.triggers.ITrigger;
import com.oracle.jmc.rjmx.triggers.TriggerRule;
import com.oracle.jmc.rjmx.triggers.internal.NotificationRegistry;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.uibuilder.FormToolkitBuilder;
import com.oracle.jmc.ui.uibuilder.IUIBuilder;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TriggerConditionSectionPart {
    private final Observer m_conditionMetadataObserver;
    private final IMRIMetadataService m_metadataService;

    public TriggerConditionSectionPart(Composite parent, FormToolkit toolkit, NotificationRegistry model, TriggerRule rule, IConnectionHandle ch) {
        Label d = toolkit.createLabel(parent, Messages.TriggerConditionSectionPart_DESCRIPTION_TITLE, 0);
        d.setLayoutData((Object)new GridData(4, 4, true, false));
        d.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        Label l1 = toolkit.createLabel(parent, "", 258);
        l1.setLayoutData((Object)new GridData(4, 4, true, false));
        if (rule.getDescription() != null) {
            FormText t = TriggerConditionSectionPart.createFormTextDescription(parent, toolkit, rule);
            t.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Label l2 = toolkit.createLabel(parent, "", 258);
        l2.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite condition = toolkit.createComposite(parent);
        FormToolkitBuilder fuib = new FormToolkitBuilder(toolkit, condition);
        final ConditionChooser conditionChooser = new ConditionChooser(true, (IUIBuilder)fuib, rule, model, ch, condition);
        conditionChooser.select((ITrigger)rule.getTrigger());
        this.m_conditionMetadataObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DisplayToolkit.safeAsyncExec(conditionChooser::updateUnit);
            }
        };
        this.m_metadataService = (IMRIMetadataService)ch.getServiceOrDummy(IMRIMetadataService.class);
        condition.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TriggerConditionSectionPart.this.m_metadataService.deleteObserver(TriggerConditionSectionPart.this.m_conditionMetadataObserver);
            }
        });
        this.m_metadataService.addObserver(this.m_conditionMetadataObserver);
        condition.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private static FormText createFormTextDescription(Composite parent, FormToolkit toolkit, TriggerRule rule) {
        String r = rule.getDescription();
        String result = TriggerConditionSectionPart.htmlify(r);
        FormText text = toolkit.createFormText(parent, false);
        try {
            text.setText("<form><p>" + result + "</p></form>", true, false);
        }
        catch (RuntimeException exp) {
            text.setText(NLS.bind((String)Messages.TriggerConditionSectionPart_ERROR_MESSAGE_COULD_NOT_PARSE_DESCRIPTION, (Object)r), false, false);
        }
        return text;
    }

    private static String htmlify(String r) {
        StringBuilder resultBuilder = new StringBuilder();
        int n = 0;
        while (n < r.length()) {
            resultBuilder.append(TriggerConditionSectionPart.transform(r.charAt(n)));
            ++n;
        }
        return resultBuilder.toString();
    }

    private static String transform(char c) {
        if (c == '\r') {
            return "<br/>";
        }
        if (c == '\n') {
            return "";
        }
        return Character.toString(c);
    }
}

