/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.tab;

import com.oracle.jmc.console.ui.notification.NotificationPlugin;
import com.oracle.jmc.console.ui.notification.widget.ActionChooser;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.services.IDiagnosticCommandService;
import com.oracle.jmc.rjmx.services.IOperation;
import com.oracle.jmc.rjmx.triggers.ITriggerAction;
import com.oracle.jmc.rjmx.triggers.actions.internal.TriggerActionDiagnosticCommand;
import com.oracle.jmc.rjmx.triggers.fields.internal.Field;
import com.oracle.jmc.rjmx.ui.operations.InvocatorBuilderForm;
import com.oracle.jmc.ui.column.TableSettings;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ActionComponentFactory
implements ActionChooser.ComponentFactory {
    private final IConnectionHandle connection;
    private final FormToolkit toolkit;

    public ActionComponentFactory(FormToolkit toolkit, IConnectionHandle connection) {
        this.toolkit = toolkit;
        this.connection = connection;
    }

    @Override
    public Composite createComponent(Composite parent, ITriggerAction action) {
        if (action instanceof TriggerActionDiagnosticCommand) {
            try {
                IDiagnosticCommandService diagCommandService = (IDiagnosticCommandService)this.connection.getServiceOrThrow(IDiagnosticCommandService.class);
                TriggerActionDiagnosticCommand diagnosticCommandAction = (TriggerActionDiagnosticCommand)action;
                final Field f = (Field)diagnosticCommandAction.getSetting("command");
                ArrayList<TableSettings.ColumnSettings> columnSettings = new ArrayList<TableSettings.ColumnSettings>();
                columnSettings.add(new TableSettings.ColumnSettings("name", Boolean.valueOf(true), Integer.valueOf(150), null));
                columnSettings.add(new TableSettings.ColumnSettings("description", Boolean.valueOf(false), Integer.valueOf(200), null));
                columnSettings.add(new TableSettings.ColumnSettings("value", Boolean.valueOf(false), Integer.valueOf(200), null));
                columnSettings.add(new TableSettings.ColumnSettings("type", Boolean.valueOf(true), Integer.valueOf(100), null));
                TableSettings tableSettings = new TableSettings(null, columnSettings);
                SashForm sash = new SashForm(parent, 256);
                InvocatorBuilderForm invocatorForm = new InvocatorBuilderForm(sash, this.toolkit, false, tableSettings, new InvocatorBuilderForm.InvocatorUpdateListener(){

                    public void onInvocatorUpdated(IOperation operation, Callable<?> invocator) {
                        f.setValue(invocator == null ? "" : invocator.toString());
                    }
                });
                invocatorForm.setOperations(diagCommandService.getOperations());
                return sash;
            }
            catch (Exception e) {
                NotificationPlugin.getDefault().getLogger().log(Level.FINE, "Could not create diagnostic command ui for trigger action", e);
            }
        }
        return null;
    }
}

