/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.action;

import com.oracle.jmc.alert.AlertObject;
import com.oracle.jmc.alert.AlertPlugin;
import com.oracle.jmc.alert.NotificationUIToolkit;
import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.console.ui.notification.action.Messages;
import com.oracle.jmc.core.MCFile;
import com.oracle.jmc.core.idesupport.IDESupportToolkit;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderToolkit;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.rjmx.services.jfr.IRecordingDescriptor;
import com.oracle.jmc.rjmx.triggers.TriggerEvent;
import com.oracle.jmc.ui.MCPathEditorInput;
import com.oracle.jmc.ui.WorkbenchToolkit;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPathEditorInput;

public class WriteAndOpenRecordingJob
extends Job {
    private final String serverName;
    private final IFlightRecorderService service;
    private final MCFile path;
    private final IQuantity timerange;
    private final boolean open;
    private TriggerEvent event;

    public WriteAndOpenRecordingJob(String jobName, String serverName, IFlightRecorderService service, MCFile path, IQuantity timerange, boolean open, TriggerEvent event) {
        super(jobName);
        this.service = service;
        this.serverName = serverName;
        this.path = path;
        this.timerange = timerange;
        this.open = open;
        this.event = event;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String recordingName;
        try {
            IRecordingDescriptor descriptor = this.findRecording();
            if (descriptor == null) {
                RJMXPlugin.getDefault().getLogger().severe("There is no usable recording running at " + this.serverName);
                return new Status(4, "com.oracle.jmc.console.ui.notification", Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_COULD_NOT_FIND_RECORDING);
            }
            recordingName = descriptor.getName();
            File writtenFile = this.writeFile(monitor, descriptor, this.timerange);
            if (this.open) {
                WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(writtenFile));
            } else {
                this.showAlert(writtenFile, this.event);
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not dump recording. Faulty rule in console?", e);
            return new Status(4, "com.oracle.jmc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_DUMPING_RECORDING, (Object)this.serverName), (Throwable)e);
        }
        return new Status(0, "com.oracle.jmc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)recordingName));
    }

    private void showAlert(File file, TriggerEvent event) {
        String serverName = event.getSource().getServerDescriptor().getDisplayName();
        String message = NotificationUIToolkit.prettyPrint((TriggerEvent)event, (String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_DUMP_SUCCESSFUL_PATH, (Object)file.getAbsolutePath()));
        AlertObject ao = new AlertObject(event.getCreationTime(), serverName, event.getRule(), message, null);
        AlertPlugin.getDefault().addAlertObject(ao);
    }

    private IRecordingDescriptor findRecording() throws FlightRecorderException {
        return FlightRecorderToolkit.getDescriptorByTimerange((List)this.service.getAvailableRecordings(), (IQuantity)this.timerange);
    }

    private File writeFile(IProgressMonitor monitor, IRecordingDescriptor descriptor, IQuantity duration) throws FlightRecorderException, IOException {
        InputStream stream = this.service.openStream(descriptor, duration, false);
        try {
            File file = IDESupportToolkit.writeToUniqueFile((MCFile)this.path, (InputStream)stream, (IProgressMonitor)monitor);
            return file;
        }
        finally {
            IOToolkit.closeSilently((Closeable)stream);
        }
    }
}

