/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.action;

import com.oracle.jmc.alert.AlertObject;
import com.oracle.jmc.alert.AlertPlugin;
import com.oracle.jmc.alert.NotificationUIToolkit;
import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.console.ui.notification.NotificationPlugin;
import com.oracle.jmc.console.ui.notification.action.Messages;
import com.oracle.jmc.console.ui.notification.action.TriggerActionRecordingToolkit;
import com.oracle.jmc.core.MCFile;
import com.oracle.jmc.core.StatusFactory;
import com.oracle.jmc.core.idesupport.IDESupportToolkit;
import com.oracle.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import com.oracle.jmc.flightrecorder.configuration.recording.RecordingOptionsBuilder;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.rjmx.services.jfr.IRecordingDescriptor;
import com.oracle.jmc.rjmx.triggers.IActivatableTriggerAction;
import com.oracle.jmc.rjmx.triggers.TriggerAction;
import com.oracle.jmc.rjmx.triggers.TriggerEvent;
import com.oracle.jmc.ui.MCPathEditorInput;
import com.oracle.jmc.ui.WorkbenchToolkit;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPathEditorInput;

public class TriggerActionStartTimeBoundRecording
extends TriggerAction
implements IActivatableTriggerAction {
    public static final int MAX_CONTINUOUS_ERROR_COUNT = 10;
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            NotificationPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        this.startTimeBoundRecording(service, event);
    }

    private void startTimeBoundRecording(IFlightRecorderService service, TriggerEvent event) throws FlightRecorderException {
        IQuantity duration = this.getSetting("timerange").getQuantity();
        try {
            RecordingOptionsBuilder b = new RecordingOptionsBuilder((IRecorderConfigurationService)service);
            b.duration(duration);
            String name = this.getSetting("name").getString();
            if (++this.recordingNumber > 1) {
                name = String.valueOf(name) + " " + this.recordingNumber;
            }
            b.name(name);
            MCFile path = IDESupportToolkit.createFileResource((String)this.getSetting("file").getFileName());
            IRecordingDescriptor descriptor = service.start(b.build(), TriggerActionRecordingToolkit.getTemplate("Profiling", service));
            boolean open = this.getSetting("open").getBoolean();
            if (!descriptor.isContinuous()) {
                new WaitAndOpenJob(service, descriptor, event, path, open).schedule(duration.clampedLongValueIn((IUnit)UnitLookup.MILLISECONDS));
            }
        }
        catch (QuantityConversionException e) {
            throw new FlightRecorderException(null, (Throwable)e);
        }
    }

    private File dumpFile(IProgressMonitor monitor, IFlightRecorderService service, IRecordingDescriptor descriptor, MCFile path) throws IOException, FlightRecorderException {
        InputStream stream = service.openStream(descriptor, false);
        try {
            File file = IDESupportToolkit.writeToUniqueFile((MCFile)path, (InputStream)stream, (IProgressMonitor)monitor);
            return file;
        }
        finally {
            IOToolkit.closeSilently((Closeable)stream);
        }
    }

    private void showAlert(File file, TriggerEvent event) {
        AlertObject ao = new AlertObject(event.getCreationTime(), event.getSource().getServerDescriptor().getDisplayName(), event.getRule(), NotificationUIToolkit.prettyPrint((TriggerEvent)event, (String)NLS.bind((String)Messages.TriggerActionStartTimeBoundRecording_MESSAGE_RECORDING_SUCCESSFUL_PATH, (Object)file.getPath())), null);
        AlertPlugin.getDefault().addAlertObject(ao);
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.supportsJfrAction(handle);
    }

    public boolean isActivatable(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.isActivatableJfrAction(handle);
    }

    private class WaitAndOpenJob
    extends Job {
        private final IFlightRecorderService m_service;
        private IRecordingDescriptor m_descriptor;
        private final MCFile m_path;
        private int m_updateErrorCount;
        private final boolean m_open;
        private final TriggerEvent m_event;

        public WaitAndOpenJob(IFlightRecorderService service, IRecordingDescriptor descriptor, TriggerEvent event, MCFile path, boolean open) {
            super(descriptor.getName());
            this.m_updateErrorCount = 0;
            this.m_service = service;
            this.m_descriptor = descriptor;
            this.m_event = event;
            this.m_path = path;
            this.m_open = open;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block8: {
                try {
                    this.m_descriptor = this.m_service.getUpdatedRecordingDescription(this.m_descriptor);
                    this.m_updateErrorCount = 0;
                }
                catch (FlightRecorderException e) {
                    NotificationPlugin.getDefault().getLogger().severe("Problem updating a flight recording on the " + this.m_descriptor.getName() + " JVM");
                    if (++this.m_updateErrorCount <= 10) break block8;
                    return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundRecording_UPDATE_STATUS_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
                }
            }
            if (this.m_descriptor.getState() != IRecordingDescriptor.RecordingState.STOPPED) {
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
            try {
                File writtenFile = TriggerActionStartTimeBoundRecording.this.dumpFile(monitor, this.m_service, this.m_descriptor, this.m_path);
                if (this.m_open) {
                    WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(writtenFile));
                } else {
                    TriggerActionStartTimeBoundRecording.this.showAlert(writtenFile, this.m_event);
                }
                return StatusFactory.createOk((String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)this.m_descriptor.getName()));
            }
            catch (FlightRecorderException e) {
                return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundRecording_SERVICE_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
            catch (IOException e) {
                return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundRecording_IO_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
        }
    }
}

