/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.action;

import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.console.ui.notification.NotificationPlugin;
import com.oracle.jmc.console.ui.notification.action.TriggerActionRecordingToolkit;
import com.oracle.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import com.oracle.jmc.flightrecorder.configuration.recording.RecordingOptionsBuilder;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.rjmx.triggers.IActivatableTriggerAction;
import com.oracle.jmc.rjmx.triggers.TriggerAction;
import com.oracle.jmc.rjmx.triggers.TriggerEvent;

public class TriggerActionStartContinuousRecording
extends TriggerAction
implements IActivatableTriggerAction {
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            NotificationPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        try {
            RecordingOptionsBuilder b = new RecordingOptionsBuilder((IRecorderConfigurationService)service);
            b.duration(0L);
            String name = this.getSetting("name").getString();
            if (++this.recordingNumber > 1) {
                name = String.valueOf(name) + " " + this.recordingNumber;
            }
            b.name(name);
            service.start(b.build(), TriggerActionRecordingToolkit.getTemplate("Continuous", service));
        }
        catch (QuantityConversionException e) {
            throw new FlightRecorderException(null, (Throwable)e);
        }
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.supportsJfrAction(handle);
    }

    public boolean isActivatable(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.isActivatableJfrAction(handle);
    }
}

