/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.action;

import com.oracle.jmc.common.unit.IConstrainedMap;
import com.oracle.jmc.common.unit.IDescribedMap;
import com.oracle.jmc.console.ui.notification.action.Messages;
import com.oracle.jmc.flightrecorder.configuration.events.EventOptionID;
import com.oracle.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import com.oracle.jmc.flightrecorder.controlpanel.ui.model.EventConfiguration;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import java.io.IOException;
import java.text.ParseException;

public class TriggerActionRecordingToolkit {
    private TriggerActionRecordingToolkit() {
        throw new Error("Don't instantiate");
    }

    protected static IConstrainedMap<EventOptionID> getTemplate(String name, IFlightRecorderService service) throws FlightRecorderException {
        for (String templateXML : service.getServerTemplates()) {
            EventConfiguration template;
            try {
                template = new EventConfiguration(EventConfiguration.createModel((String)templateXML));
            }
            catch (ParseException e) {
                continue;
            }
            catch (IOException e) {
                continue;
            }
            if (!template.getName().equals(name)) continue;
            IDescribedMap options = service.getDefaultEventOptions();
            return template.getEventOptions(options.emptyWithSameConstraints());
        }
        return null;
    }

    public static boolean supportsJfrAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IFlightRecorderService.class) != null;
    }

    public static boolean isActivatableJfrAction(IConnectionHandle handle) {
        IFlightRecorderService flrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
        try {
            return flrService != null && (flrService.isEnabled() || ControlPanel.askUserForEnable((IFlightRecorderService)flrService, (String)Messages.TriggerActionRecordingToolkit_COMMERCIAL_FEATURES_QUESTION_TRIGGERS));
        }
        catch (FlightRecorderException e) {
            return false;
        }
    }
}

