/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification.action;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.console.ui.notification.action.Messages;
import com.oracle.jmc.console.ui.notification.action.WriteAndOpenRecordingJob;
import com.oracle.jmc.core.MCFile;
import com.oracle.jmc.core.idesupport.IDESupportToolkit;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.RJMXPlugin;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderException;
import com.oracle.jmc.rjmx.services.jfr.FlightRecorderToolkit;
import com.oracle.jmc.rjmx.services.jfr.IFlightRecorderService;
import com.oracle.jmc.rjmx.triggers.TriggerAction;
import com.oracle.jmc.rjmx.triggers.TriggerEvent;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class TriggerActionDumpRecording
extends TriggerAction {
    public void handleNotificationEvent(final TriggerEvent event) {
        final IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            RJMXPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource() + " JVM");
            return;
        }
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Job job = TriggerActionDumpRecording.this.createDumpFlightRecordingJob(event, service);
                job.schedule();
            }
        });
    }

    protected Job createDumpFlightRecordingJob(TriggerEvent event, IFlightRecorderService service) {
        MCFile path = IDESupportToolkit.createFileResource((String)this.getSetting("file").getFileName());
        IQuantity timerange = this.getSetting("timerange").getQuantity();
        Boolean open = this.getSetting("open").getBoolean();
        return new WriteAndOpenRecordingJob(NLS.bind((String)Messages.TriggerActionDumpRecording_DUMPING_JOB_NAME, (Object)event.getRule().getName()), event.getSource().getServerDescriptor().getDisplayName(), service, path, timerange, open, event);
    }

    public boolean supportsAction(IConnectionHandle handle) {
        IFlightRecorderService jfrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
        try {
            return jfrService != null && jfrService.isEnabled() && FlightRecorderToolkit.getDescriptorByTimerange((List)jfrService.getAvailableRecordings(), (IQuantity)UnitLookup.MILLISECONDS.quantity(0L)) != null;
        }
        catch (FlightRecorderException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Got exception when checking for available recordings in JVM", e);
            return false;
        }
    }
}

