/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.console.ui.notification;

import com.oracle.jmc.console.ui.editor.IConsolePageStateHandler;
import com.oracle.jmc.console.ui.notification.NotificationPlugin;
import com.oracle.jmc.console.ui.notification.tab.TriggerDetailsPage;
import com.oracle.jmc.console.ui.notification.tab.TriggerSectionPart;
import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.triggers.TriggerRule;
import com.oracle.jmc.rjmx.triggers.internal.NotificationRegistry;
import com.oracle.jmc.ui.misc.MCLayoutFactory;
import javax.inject.Inject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TriggerTab
implements IConsolePageStateHandler {
    private String guid;
    private NotificationRegistry model;

    @Inject
    protected void createPageContent(IManagedForm managedForm, IConnectionHandle connection) {
        this.model = NotificationPlugin.getDefault().getNotificationRepository();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        SashForm sashForm = new SashForm(body, 256);
        toolkit.adapt((Control)sashForm, false, false);
        sashForm.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        body.setLayout(MCLayoutFactory.createFormPageLayout());
        TriggerSectionPart masterPart = new TriggerSectionPart((Composite)sashForm, toolkit, this.model, connection);
        final TriggerDetailsPage details = new TriggerDetailsPage((Composite)sashForm, this.model, connection, masterPart.getRefresher(), toolkit);
        masterPart.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selected instanceof TriggerRule) {
                    details.showRule((TriggerRule)selected);
                }
            }
        });
        this.model.activateTriggersFor(connection);
        this.guid = connection.getServerDescriptor().getGUID();
    }

    public boolean saveState(IMemento state) {
        return false;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.deactivateTriggersFor(this.guid);
        }
    }
}

