/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.misc;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.internal.IActionProvider;
import com.oracle.jmc.common.internal.IUserAction;
import com.oracle.jmc.rjmx.ui.RJMXUIPlugin;
import com.oracle.jmc.ui.misc.IGraphical;
import com.oracle.jmc.ui.misc.IPrintable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;

public class SimpleActionProvider
implements IActionProvider,
IDescribable,
IGraphical,
IPrintable {
    private final String text;
    private final String description;
    private final ImageDescriptor icon;
    private final List<? extends IUserAction> actions;
    private final int doubleClickActionIndex;

    public SimpleActionProvider(String text, String description, ImageDescriptor icon, List<? extends IUserAction> actions, int doubleClickActionIndex) {
        this.text = text;
        this.description = description;
        this.actions = actions;
        this.icon = icon;
        this.doubleClickActionIndex = doubleClickActionIndex;
    }

    public SimpleActionProvider(String text, String description) {
        this(text, description, null, null, 0);
    }

    public boolean hasChildren() {
        return false;
    }

    public Collection<? extends IActionProvider> getChildren() {
        return Collections.emptyList();
    }

    public Collection<? extends IUserAction> getActions() {
        return this.actions != null ? this.actions : Collections.emptyList();
    }

    public IUserAction getDefaultAction() {
        return this.actions != null ? this.actions.get(this.doubleClickActionIndex) : null;
    }

    public String getName() {
        return this.text;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.icon == null ? RJMXUIPlugin.getDefault().getMCImageDescriptor("remove-obj-off.gif") : this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public FontDescriptor getFontDescriptor() {
        return JFaceResources.getFontRegistry().defaultFontDescriptor().setStyle(2);
    }
}

