/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.rjmx.subscription.MRI;
import org.eclipse.core.runtime.IAdaptable;

public class StatisticsCalculator
implements IAdaptable {
    private long count;
    private double last = Double.NaN;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double mean;
    private double M2;
    private final MRI mri;
    private IUnit unit;
    public static final IMemberAccessor<MRI, StatisticsCalculator> GET_ATTRIBUTE = new IMemberAccessor<MRI, StatisticsCalculator>(){

        public MRI getMember(StatisticsCalculator c) {
            return c.getAttribute();
        }
    };
    public static final IMemberAccessor<Object, StatisticsCalculator> GET_LAST = new IMemberAccessor<Object, StatisticsCalculator>(){

        public Object getMember(StatisticsCalculator c) {
            return c.decode(c.getLast());
        }
    };
    public static final IMemberAccessor<Object, StatisticsCalculator> GET_MAX = new IMemberAccessor<Object, StatisticsCalculator>(){

        public Object getMember(StatisticsCalculator c) {
            return c.decode(c.getMax());
        }
    };
    public static final IMemberAccessor<Object, StatisticsCalculator> GET_MIN = new IMemberAccessor<Object, StatisticsCalculator>(){

        public Object getMember(StatisticsCalculator c) {
            return c.decode(c.getMin());
        }
    };
    public static final IMemberAccessor<Object, StatisticsCalculator> GET_AVERAGE = new IMemberAccessor<Object, StatisticsCalculator>(){

        public Object getMember(StatisticsCalculator c) {
            return c.decode(c.getMean());
        }
    };
    public static final IMemberAccessor<Object, StatisticsCalculator> GET_SIGMA = new IMemberAccessor<Object, StatisticsCalculator>(){

        public Object getMember(StatisticsCalculator c) {
            return c.decode(c.getSigma());
        }
    };

    public StatisticsCalculator(MRI mri) {
        this.mri = mri;
    }

    public void setUnit(IUnit unit) {
        this.unit = unit;
    }

    public void addValue(double value) {
        this.last = value;
        this.max = Math.max(this.max, value);
        this.min = Math.min(this.min, value);
        ++this.count;
        double delta = value - this.mean;
        this.mean += delta / (double)this.count;
        this.M2 += delta * (value - this.mean);
    }

    public boolean reset() {
        if (this.count > 1L) {
            this.min = this.last;
            this.max = this.last;
            this.mean = this.last;
            this.count = 1L;
            this.M2 = 0.0;
            return true;
        }
        return false;
    }

    public IUnit getUnit() {
        return this.unit;
    }

    public MRI getAttribute() {
        return this.mri;
    }

    public Number getLast() {
        return this.last;
    }

    public Number getMax() {
        return this.count > 0L ? this.max : Double.NaN;
    }

    public Number getMin() {
        return this.count > 0L ? this.min : Double.NaN;
    }

    public Number getMean() {
        return this.count > 0L ? this.mean : Double.NaN;
    }

    public Number getSigma() {
        return this.count == 0L ? Double.NaN : (this.count == 1L ? 0.0 : Math.sqrt(this.M2 / (double)(this.count - 1L)));
    }

    private Object decode(Number o) {
        return this.unit == null || this.count == 0L ? o : this.unit.quantity(o);
    }

    public int hashCode() {
        return this.mri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof StatisticsCalculator && this.mri.equals((Object)((StatisticsCalculator)obj).mri);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return MRI.class.equals(adapter) ? (T)adapter.cast(this.mri) : null;
    }
}

