/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.rjmx.services.IAttribute;
import com.oracle.jmc.rjmx.services.IIndexedAttributeChild;
import com.oracle.jmc.rjmx.ui.internal.AbstractArrayElementMenuAction;
import com.oracle.jmc.rjmx.ui.messages.internal.Messages;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.IColumn;
import java.lang.reflect.Array;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;

public class RemoveArrayElementMenuAction
extends AbstractArrayElementMenuAction {
    protected RemoveArrayElementMenuAction(IMenuManager mm, ColumnManager columnsManager, IColumn column) {
        super(Messages.REMOVE_ARRAY_ELEMENT_ACTION, mm, columnsManager, column);
    }

    @Override
    protected void run(IIndexedAttributeChild selectedElement) {
        IAttribute parent = (IAttribute)selectedElement.getParent();
        Object array = parent.getValue();
        Object newArray = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array) - 1);
        if (selectedElement.getIndex() > 0) {
            System.arraycopy(array, 0, newArray, 0, selectedElement.getIndex());
        }
        if (selectedElement.getIndex() < Array.getLength(array) - 1) {
            System.arraycopy(array, selectedElement.getIndex() + 1, newArray, selectedElement.getIndex(), Array.getLength(array) - selectedElement.getIndex() - 1);
        }
        parent.setValue(newArray);
    }

    public static ActionContributionItem createRemoveArrayElementMenuActionContribution(IMenuManager mm, ColumnManager columnsManager, IColumn column) {
        return new RemoveArrayElementMenuAction(mm, columnsManager, column).getActionContribution();
    }
}

