/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.rjmx.services.IAttribute;
import com.oracle.jmc.rjmx.services.IIndexedAttributeChild;
import com.oracle.jmc.rjmx.ui.internal.AbstractArrayElementMenuAction;
import com.oracle.jmc.rjmx.ui.messages.internal.Messages;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.IColumn;
import java.lang.reflect.Array;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;

public class InsertArrayElementMenuAction
extends AbstractArrayElementMenuAction {
    private final boolean m_insertBelow;

    protected InsertArrayElementMenuAction(IMenuManager mm, ColumnManager columnsManager, IColumn column, boolean insertBelow) {
        super(insertBelow ? Messages.INSERT_ARRAY_ELEMENT_BELOW_ACTION : Messages.INSERT_ARRAY_ELEMENT_ABOVE_ACTION, mm, columnsManager, column);
        this.m_insertBelow = insertBelow;
    }

    @Override
    protected void run(IIndexedAttributeChild selectedElement) {
        IAttribute parent = (IAttribute)selectedElement.getParent();
        Object array = parent.getValue();
        Object newArray = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array) + 1);
        int selectedIndex = selectedElement.getIndex() + (this.m_insertBelow ? 1 : 0);
        if (selectedIndex > 0) {
            System.arraycopy(array, 0, newArray, 0, selectedIndex);
        }
        if (selectedIndex <= Array.getLength(array) - 1) {
            System.arraycopy(array, selectedIndex, newArray, selectedIndex + 1, Array.getLength(array) - selectedIndex);
        }
        parent.setValue(newArray);
    }

    public static ActionContributionItem createInsertArrayElementMenuActionContribution(IMenuManager mm, ColumnManager columnsManager, IColumn column, boolean insertBelow) {
        return new InsertArrayElementMenuAction(mm, columnsManager, column, insertBelow).getActionContribution();
    }
}

