/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.IMRIService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.ui.internal.IAttributeSelectionContentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeSelectionContentModel {
    private final IMRIService m_mriService;
    private final IMRIMetadataService m_mds;
    private final List<MRI> m_selectedAttributes = new ArrayList<MRI>();
    private final Map<MRI, IUnit> m_alteredUnits = new HashMap<MRI, IUnit>();
    private final List<MRI> m_initialExpanded = new ArrayList<MRI>();
    private final Set<IAttributeSelectionContentListener> listeners = new HashSet<IAttributeSelectionContentListener>();

    public AttributeSelectionContentModel(IMRIService mriService, IMRIMetadataService mds, MRI[] selected, MRI[] expanded) {
        this.m_mriService = mriService;
        this.m_mds = mds;
        this.setSelectedAttributes(selected);
        if (expanded != null) {
            MRI[] mRIArray = expanded;
            int n = expanded.length;
            int n2 = 0;
            while (n2 < n) {
                MRI attribute = mRIArray[n2];
                this.m_initialExpanded.add(attribute);
                ++n2;
            }
        }
    }

    public void setSelectedAttributes(MRI[] selection) {
        this.m_selectedAttributes.clear();
        if (selection != null) {
            MRI[] mRIArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                MRI selected = mRIArray[n2];
                this.m_selectedAttributes.add(selected);
                ++n2;
            }
        }
        this.fireSelectionChanged();
    }

    public MRI[] getSelectedAttributes() {
        return this.m_selectedAttributes.toArray(new MRI[this.m_selectedAttributes.size()]);
    }

    public MRI[] getInitialExpandedAttributes() {
        return this.m_initialExpanded.toArray(new MRI[this.m_initialExpanded.size()]);
    }

    public IMRIService getMRIService() {
        return this.m_mriService;
    }

    public Iterable<MRI> getAvailableAttributes() {
        return this.m_mriService.getMRIs();
    }

    public IMRIMetadataService getMetadataService() {
        return this.m_mds;
    }

    public IUnit getAttributeUnit(MRI attribute) {
        IUnit unit = this.m_alteredUnits.get(attribute);
        if (unit == null) {
            String unitString = this.m_mds.getMetadata(attribute).getUnitString();
            unit = UnitLookup.getUnitOrNull((String)unitString);
        }
        return unit;
    }

    public void setAttributeUnit(MRI attribute, IUnit unit) {
        this.m_alteredUnits.put(attribute, unit);
        this.fireSelectionChanged();
    }

    public void commitUnitChanges() {
        for (MRI attribute : this.m_selectedAttributes) {
            IUnit unit = this.m_alteredUnits.get(attribute);
            if (unit == null) continue;
            this.m_mds.setMetadata(attribute, "UnitString", UnitLookup.getUnitIdentifier((IUnit)unit));
        }
    }

    public void addListener(IAttributeSelectionContentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IAttributeSelectionContentListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelectionChanged() {
        for (IAttributeSelectionContentListener listener : this.listeners) {
            listener.selectionChanged(this);
        }
    }
}

