/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.rjmx.subscription.IMRIMetadataProvider;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.IMRIService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIMetadataToolkit;
import com.oracle.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.oracle.jmc.ui.misc.SWTColorToolkit;
import com.oracle.jmc.ui.misc.TypedLabelProvider;
import java.awt.Color;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class AttributeLabelProvider
extends TypedLabelProvider<MRI> {
    private final IMRIMetadataService m_mds;
    private final IMRIService m_availableAttributes;
    private static final RGB UNAVAILABLE_COLOR = new RGB(192, 192, 192);

    public AttributeLabelProvider(IMRIMetadataService mds, IMRIService availableAttributes) {
        super(MRI.class);
        this.m_mds = mds;
        this.m_availableAttributes = availableAttributes;
    }

    protected String getTextTyped(MRI element) {
        return MRIMetadataToolkit.getDisplayName((IMRIMetadataService)this.m_mds, (MRI)element);
    }

    protected String getToolTipTextTyped(MRI element) {
        String path = MBeanPropertiesOrderer.mriAsTooltip(element);
        String desc = this.m_mds.getMetadata(element).getDescription();
        return desc == null ? path : String.valueOf(path) + "\n" + desc;
    }

    protected Image getImageTyped(MRI mri) {
        if (this.m_availableAttributes.isMRIAvailable(mri)) {
            Color color = MRIMetadataToolkit.getColor((IMRIMetadataProvider)this.m_mds.getMetadata(mri));
            return SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)color));
        }
        return SWTColorToolkit.getColorThumbnail((RGB)UNAVAILABLE_COLOR);
    }

    protected org.eclipse.swt.graphics.Color getForegroundTyped(MRI element) {
        if (this.m_availableAttributes.isMRIAvailable(element)) {
            return null;
        }
        return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
    }
}

