/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.TypedUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.rjmx.subscription.IMRIMetadata;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIMetadataToolkit;
import com.oracle.jmc.rjmx.ui.celleditors.TypedEditingSupport;
import com.oracle.jmc.rjmx.ui.internal.AttributeLabelProvider;
import com.oracle.jmc.rjmx.ui.internal.AttributeSelectionContentModel;
import com.oracle.jmc.rjmx.ui.internal.AttributeSelectionViewModel;
import com.oracle.jmc.rjmx.ui.messages.internal.Messages;
import com.oracle.jmc.ui.handlers.ActionToolkit;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.TypedLabelProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class AttributeConfiguratorTableFactory {
    private AttributeConfiguratorTableFactory() {
        throw new UnsupportedOperationException("Should not be instantiated!");
    }

    public static TableViewer createAttributeConfiguratorTable(Composite parent, AttributeLabelProvider alp, AttributeSelectionViewModel viewModel, AttributeSelectionContentModel selectorModel, Runnable listener) {
        Map<KindOfQuantity<?>, List<IUnit>> types = AttributeConfiguratorTableFactory.getTypes();
        TableViewer viewer = new TableViewer(parent, 68354);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn nameColumn = new TableViewerColumn(viewer, 0);
        nameColumn.getColumn().setWidth(200);
        nameColumn.getColumn().setText(Messages.COLUMN_ATTRIBUTE_NAME);
        nameColumn.getColumn().setToolTipText(Messages.COLUMN_ATTRIBUTE_DESCRIPTION);
        nameColumn.setLabelProvider((CellLabelProvider)alp);
        TableViewerColumn typeColumn = new TableViewerColumn(viewer, 0);
        typeColumn.getColumn().setWidth(150);
        typeColumn.getColumn().setText(Messages.COLUMN_CONTENT_TYPE_NAME);
        typeColumn.getColumn().setToolTipText(Messages.COLUMN_CONTENT_TYPE_DESCRIPTION);
        typeColumn.setLabelProvider(AttributeConfiguratorTableFactory.createTypeLabelProvider(viewModel, selectorModel));
        typeColumn.setEditingSupport(AttributeConfiguratorTableFactory.createTypeEditingSupport(viewModel, selectorModel, types, viewer, listener));
        TableViewerColumn unitColumn = new TableViewerColumn(viewer, 0);
        unitColumn.getColumn().setWidth(150);
        unitColumn.getColumn().setText(Messages.COLUMN_UNIT_TYPE_NAME);
        unitColumn.getColumn().setToolTipText(Messages.COLUMN_UNIT_TYPE_DESCRIPTION);
        unitColumn.setLabelProvider(AttributeConfiguratorTableFactory.createUnitLabelProvider(selectorModel));
        unitColumn.setEditingSupport(AttributeConfiguratorTableFactory.createUnitEditingSupport(viewModel, selectorModel, types, viewer, listener));
        MCContextMenuManager menu = MCContextMenuManager.create((Control)viewer.getControl());
        types.entrySet().stream().sorted((e1, e2) -> e1.getKey().getName().compareTo(e2.getKey().getName())).forEachOrdered(entry -> {
            KindOfQuantity<?> kind = entry.getKey();
            MenuManager typeUnit = new MenuManager(MessageFormat.format(Messages.CONTEXT_MENU_UNIT_TYPE_NAME, kind.getName()));
            for (IUnit unit : entry.getValue()) {
                typeUnit.add(ActionToolkit.action(() -> {
                    Object[] array = ((StructuredSelection)viewer.getSelection()).toArray();
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] instanceof MRI) {
                            MRI attribute = (MRI)array[i];
                            selectorModel.setAttributeUnit(attribute, unit);
                            viewer.refresh();
                            listener.run();
                        }
                        ++i;
                    }
                }, (String)unit.getLocalizedDescription()));
            }
            menu.add((IContributionItem)typeUnit);
            typeUnit.setVisible(false);
            viewer.addSelectionChangedListener(e -> {
                typeUnit.setVisible(!e.getSelection().isEmpty());
                menu.update(true);
            });
        });
        return viewer;
    }

    private static TypedLabelProvider<MRI> createTypeLabelProvider(final AttributeSelectionViewModel viewModel, final AttributeSelectionContentModel selectorModel) {
        return new TypedLabelProvider<MRI>(MRI.class){

            protected String getTextTyped(MRI attribute) {
                IUnit unit = selectorModel.getAttributeUnit(attribute);
                if (unit != null) {
                    return unit.getContentType().getName();
                }
                if (viewModel.getContentType() == null) {
                    return Messages.VALUE_NO_TYPE;
                }
                return viewModel.getContentType().getName();
            }
        };
    }

    private static TypedEditingSupport<MRI> createTypeEditingSupport(final AttributeSelectionViewModel viewModel, final AttributeSelectionContentModel selectorModel, final Map<KindOfQuantity<?>, List<IUnit>> types, final TableViewer table, final Runnable listener) {
        return new TypedEditingSupport<MRI>((ColumnViewer)table, MRI.class){

            @Override
            public boolean canEdit(Object element) {
                if (viewModel.getContentType() != null) {
                    return false;
                }
                if (element instanceof MRI) {
                    MRI mri = (MRI)element;
                    IMRIMetadata metadata = selectorModel.getMetadataService().getMetadata(mri);
                    return MRIMetadataToolkit.isNumerical((IMRIMetadata)metadata);
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditorTyped(MRI attribute) {
                return new AttributeComboBoxCellEditor((Composite)table.getTable(), this.getTypeDisplayNames());
            }

            private String[] getTypeDisplayNames() {
                if (viewModel.getContentType() != null) {
                    return new String[]{viewModel.getContentType().getName()};
                }
                ArrayList<String> typeNames = new ArrayList<String>(types.size());
                for (KindOfQuantity type : types.keySet()) {
                    typeNames.add(type.getName());
                }
                return typeNames.toArray(new String[typeNames.size()]);
            }

            @Override
            protected Object getValueTyped(MRI attribute) {
                IUnit unit = selectorModel.getAttributeUnit(attribute);
                if (unit == null) {
                    return 0;
                }
                int index = 0;
                for (KindOfQuantity type : types.keySet()) {
                    if (type.equals(unit.getContentType())) {
                        return index;
                    }
                    ++index;
                }
                return 0;
            }

            @Override
            protected void setValueTyped(MRI attribute, Object value) {
                if (!(value instanceof Number)) {
                    return;
                }
                ContentType<?> contentType = viewModel.getContentType();
                if (contentType != null) {
                    if (contentType instanceof KindOfQuantity) {
                        selectorModel.setAttributeUnit(attribute, (IUnit)((KindOfQuantity)contentType).getDefaultUnit());
                        table.refresh();
                    }
                    return;
                }
                TypedUnit unit = null;
                int index = ((Number)value).intValue();
                int pos = 0;
                for (KindOfQuantity type : types.keySet()) {
                    if (pos == index) {
                        unit = type.getDefaultUnit();
                        break;
                    }
                    ++pos;
                }
                selectorModel.setAttributeUnit(attribute, (IUnit)unit);
                table.refresh();
                listener.run();
            }
        };
    }

    private static TypedLabelProvider<MRI> createUnitLabelProvider(final AttributeSelectionContentModel selectorModel) {
        return new TypedLabelProvider<MRI>(MRI.class){

            protected String getTextTyped(MRI attribute) {
                IUnit unit = selectorModel.getAttributeUnit(attribute);
                if (unit != null) {
                    return unit.getLocalizedDescription();
                }
                return Messages.VALUE_NO_UNIT;
            }
        };
    }

    private static TypedEditingSupport<MRI> createUnitEditingSupport(final AttributeSelectionViewModel viewModel, final AttributeSelectionContentModel selectorModel, final Map<KindOfQuantity<?>, List<IUnit>> types, final TableViewer table, final Runnable listener) {
        return new TypedEditingSupport<MRI>((ColumnViewer)table, MRI.class){

            @Override
            public boolean canEdit(Object element) {
                if (element instanceof MRI) {
                    MRI mri = (MRI)element;
                    IMRIMetadata metadata = selectorModel.getMetadataService().getMetadata(mri);
                    return MRIMetadataToolkit.isNumerical((IMRIMetadata)metadata);
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditorTyped(MRI attribute) {
                return new AttributeComboBoxCellEditor((Composite)table.getTable(), this.getUnitsForType(attribute));
            }

            private String[] getUnitsForType(MRI attribute) {
                IUnit unit = selectorModel.getAttributeUnit(attribute);
                if (unit == null) {
                    ContentType<?> contentType = viewModel.getContentType();
                    if (contentType instanceof KindOfQuantity) {
                        unit = ((KindOfQuantity)contentType).getDefaultUnit();
                    } else {
                        return new String[0];
                    }
                }
                List units = (List)types.get(unit.getContentType());
                String[] unitNames = new String[units.size()];
                int i = 0;
                while (i < units.size()) {
                    unitNames[i] = ((IUnit)units.get(i)).getLocalizedDescription();
                    ++i;
                }
                return unitNames;
            }

            @Override
            protected Object getValueTyped(MRI attribute) {
                IUnit unit = selectorModel.getAttributeUnit(attribute);
                if (unit == null) {
                    return 0;
                }
                List units = (List)types.get(unit.getContentType());
                int index = units.indexOf(unit);
                if (index < 0) {
                    index = 0;
                }
                return index;
            }

            @Override
            protected void setValueTyped(MRI attribute, Object value) {
                IUnit unit = selectorModel.getAttributeUnit(attribute);
                if (!(value instanceof Number) || unit == null && viewModel.getContentType() == null) {
                    return;
                }
                int index = ((Number)value).intValue();
                List units = (List)types.get(unit != null ? unit.getContentType() : viewModel.getContentType());
                selectorModel.setAttributeUnit(attribute, (IUnit)units.get(index));
                table.refresh();
                listener.run();
            }
        };
    }

    private static Map<KindOfQuantity<?>, List<IUnit>> getTypes() {
        TreeMap types = new TreeMap(new Comparator<KindOfQuantity<?>>(){

            @Override
            public int compare(KindOfQuantity<?> o1, KindOfQuantity<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (KindOfQuantity type : UnitLookup.getKindsOfQuantity()) {
            ArrayList units = new ArrayList(type.getCommonUnits());
            types.put(type, units);
        }
        return types;
    }

    private static class AttributeComboBoxCellEditor
    extends ComboBoxCellEditor {
        AttributeComboBoxCellEditor(Composite parent, String[] items) {
            super(parent, items, 8);
            this.setActivationStyle(15);
        }

        protected Control createControl(Composite parent) {
            final CCombo combo = (CCombo)super.createControl(parent);
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!combo.getListVisible()) {
                        this.focusLost();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return combo;
        }
    }
}

