/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.IMRIService;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.ui.RJMXUIPlugin;
import com.oracle.jmc.rjmx.ui.internal.AttributeSelectionViewModel;
import com.oracle.jmc.rjmx.ui.internal.AttributeSelectorWizardDialog;
import com.oracle.jmc.rjmx.ui.internal.IAttributeSet;
import com.oracle.jmc.rjmx.ui.internal.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class AddAttibutesAction
extends Action {
    private static final MRI[] EMPTY = new MRI[0];
    private final IMRIService availableAttributes;
    private final IMRIMetadataService mds;
    private final IAttributeSet attributSet;
    private final boolean numericalsOnly;

    public AddAttibutesAction(IMRIMetadataService mds, IMRIService availableAttributes, IAttributeSet attributSet) {
        this(mds, availableAttributes, attributSet, true);
    }

    public AddAttibutesAction(IMRIMetadataService mds, IMRIService availableAttributes, IAttributeSet attributSet, boolean numericalsOnly) {
        super(Messages.ADD_ATTIBUTES_ACTION_TEXT, RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif"));
        this.attributSet = attributSet;
        this.numericalsOnly = numericalsOnly;
        this.setToolTipText(Messages.ADD_ATTIBUTES_ACTION_TOOLTIP);
        this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj-off.gif"));
        this.setId("add");
        this.mds = mds;
        this.availableAttributes = availableAttributes;
    }

    public void run() {
        AttributeSelectionViewModel viewModel = this.allowMultiple() ? this.createSelectSeveralAttributesViewModel() : this.createSelectOneAttributeViewModel();
        AttributeSelectorWizardDialog d = new AttributeSelectorWizardDialog(Display.getCurrent().getActiveShell(), viewModel);
        if (d.open(this.availableAttributes, this.mds, EMPTY, (MRI[])this.attributSet.elements()) == 0) {
            this.attributSet.add(d.getSelectedAttributes());
            return;
        }
    }

    private AttributeSelectionViewModel createSelectOneAttributeViewModel() {
        return new AttributeSelectionViewModel(this.getContentType(), false, this.numericalsOnly, com.oracle.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTE_TITLE, com.oracle.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTE_TITLE, com.oracle.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTE_DESCRIPTION, com.oracle.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTE_TITLE, com.oracle.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTE_DESCRIPTION);
    }

    private AttributeSelectionViewModel createSelectSeveralAttributesViewModel() {
        return new AttributeSelectionViewModel(this.getContentType(), this.allowMultiple(), this.numericalsOnly, com.oracle.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTES_TITLE, com.oracle.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTES_TITLE, com.oracle.jmc.rjmx.ui.messages.internal.Messages.SELECT_ATTRIBUTES_DESCRIPTION, com.oracle.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTES_TITLE, com.oracle.jmc.rjmx.ui.messages.internal.Messages.CONFIGURE_ATTRIBUTES_DESCRIPTION);
    }

    protected ContentType<?> getContentType() {
        return null;
    }

    protected boolean allowMultiple() {
        return true;
    }
}

