/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.internal;

import com.oracle.jmc.rjmx.services.IAttribute;
import com.oracle.jmc.rjmx.services.IIndexedAttributeChild;
import com.oracle.jmc.rjmx.services.IReadOnlyAttribute;
import com.oracle.jmc.rjmx.ui.celleditors.TypedEditingSupport;
import com.oracle.jmc.ui.column.ColumnManager;
import com.oracle.jmc.ui.column.IColumn;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class AbstractArrayElementMenuAction
extends Action {
    private final ActionContributionItem m_contribution;
    private final ColumnManager m_columnsManager;
    private final IColumn m_column;
    private IIndexedAttributeChild m_element;

    protected AbstractArrayElementMenuAction(String name, final IMenuManager mm, ColumnManager columnsManager, IColumn column) {
        super(name);
        this.m_columnsManager = columnsManager;
        this.m_column = column;
        this.m_columnsManager.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                List selectedRows = selection.toList();
                boolean visible = false;
                boolean enabled = false;
                if (AbstractArrayElementMenuAction.this.isColumnVisible() && AbstractArrayElementMenuAction.this.isActionApplicable(selectedRows)) {
                    visible = true;
                    AbstractArrayElementMenuAction.this.m_element = AbstractArrayElementMenuAction.this.getSelectedElement(selectedRows);
                    enabled = AbstractArrayElementMenuAction.this.isActionValid(AbstractArrayElementMenuAction.this.m_element);
                } else {
                    AbstractArrayElementMenuAction.this.m_element = null;
                }
                if (AbstractArrayElementMenuAction.this.m_contribution.isVisible() != visible || AbstractArrayElementMenuAction.this.isEnabled() != enabled) {
                    AbstractArrayElementMenuAction.this.m_contribution.setVisible(visible);
                    AbstractArrayElementMenuAction.this.setEnabled(enabled);
                    mm.update(true);
                }
            }
        });
        this.m_contribution = new ActionContributionItem((IAction)this);
        this.m_contribution.setVisible(false);
        this.setEnabled(false);
    }

    protected ActionContributionItem getActionContribution() {
        return this.m_contribution;
    }

    protected IIndexedAttributeChild getSelectedElement() {
        return this.m_element;
    }

    private boolean isColumnVisible() {
        return this.m_columnsManager.getColumnStates().filter(c -> c.getColumn().equals(this.m_column)).findAny().map(ColumnManager.IColumnState::isVisible).orElse(false);
    }

    private boolean isActionApplicable(List<?> selectedRows) {
        return selectedRows.size() == 1 && selectedRows.get(0) instanceof IIndexedAttributeChild;
    }

    private IIndexedAttributeChild getSelectedElement(List<?> selectedRows) {
        return (IIndexedAttributeChild)selectedRows.get(0);
    }

    private boolean isActionValid(IIndexedAttributeChild selectedElement) {
        IReadOnlyAttribute parent = selectedElement.getParent();
        return parent instanceof IAttribute && this.m_column.getEditingSupport() != null && ((TypedEditingSupport)this.m_column.getEditingSupport()).canEdit(parent);
    }

    public void run() {
        if (this.m_element != null) {
            this.run(this.m_element);
            this.m_columnsManager.getViewer().refresh();
        }
    }

    protected abstract void run(IIndexedAttributeChild var1);
}

