/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.celleditors;

import com.oracle.jmc.rjmx.ui.celleditors.ParsingCellEditor;
import java.lang.reflect.Constructor;
import org.eclipse.swt.widgets.Composite;

class StringConstructorCellEditor<T>
extends ParsingCellEditor {
    private Constructor<? extends T> constructor;
    boolean allowNull;

    public StringConstructorCellEditor(Composite parent, Class<? extends T> type) {
        this(parent, type, true);
    }

    public StringConstructorCellEditor(Composite parent, Class<? extends T> type, boolean allowNull) {
        super(parent);
        this.allowNull = allowNull;
        try {
            this.constructor = type.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean allowClear() {
        return this.allowNull;
    }

    @Override
    protected Object parse(String str) throws Exception {
        return this.constructor.newInstance(str);
    }

    public static boolean checkContructor(Class<?> forType) {
        Constructor<?>[] constructorArray = forType.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            Class<?>[] args = c.getParameterTypes();
            if (args.length == 1 && args[0].equals(String.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

