/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.celleditors;

import com.oracle.jmc.rjmx.ui.celleditors.ParsingCellEditor;
import com.oracle.jmc.rjmx.ui.messages.internal.Messages;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class DateCellEditor
extends ParsingCellEditor {
    private static final int[] STYLES;
    private DateFormat lastParsedFormat = null;

    static {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[2] = 1;
        nArray[3] = 3;
        STYLES = nArray;
    }

    public DateCellEditor(Composite parent) {
        super(parent);
    }

    @Override
    protected String format(Object value) {
        if (value instanceof Date) {
            return DateFormat.getDateTimeInstance().format(value);
        }
        return super.format(value);
    }

    @Override
    protected Date parse(String str) throws Exception {
        Date date;
        str = str.trim();
        ParsePosition pp = new ParsePosition(0);
        if (this.lastParsedFormat != null && (date = this.lastParsedFormat.parse(str, pp)) != null && pp.getIndex() == str.length()) {
            return date;
        }
        int[] nArray = STYLES;
        int n = STYLES.length;
        int n2 = 0;
        while (n2 < n) {
            int dateStyle = nArray[n2];
            int[] nArray2 = STYLES;
            int n3 = STYLES.length;
            int n4 = 0;
            while (n4 < n3) {
                int timeStyle = nArray2[n4];
                DateFormat dateFormat = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
                Date date2 = dateFormat.parse(str, pp);
                if (date2 != null && pp.getIndex() == str.length()) {
                    this.lastParsedFormat = dateFormat;
                    return date2;
                }
                ++n4;
            }
            ++n2;
        }
        throw new ParseException(NLS.bind((String)Messages.DATE_PARSE_ERROR_MSG, (Object)str, (Object)this.format(new Date())));
    }
}

