/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.attributes;

import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.subscription.IMRIMetadata;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataService;
import com.oracle.jmc.rjmx.subscription.IMRITransformationFactory;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIMetadataToolkit;
import com.oracle.jmc.rjmx.ui.RJMXUIPlugin;
import com.oracle.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import com.oracle.jmc.rjmx.ui.attributes.VisualizeWizardPage;
import com.oracle.jmc.rjmx.ui.internal.SectionPartManager;
import com.oracle.jmc.ui.wizards.OnePageWizardDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionProviderAction;

public class VisualizeAction
extends SelectionProviderAction {
    private final IConnectionHandle connection;
    private List<MRI> numericals = Collections.emptyList();
    private final SectionPartManager sectionPartManager;
    private final IMRITransformationFactory transformationFactory;

    public VisualizeAction(String text, SectionPartManager sectionPartManager, IConnectionHandle connection, ISelectionProvider selectionProvider) {
        this(text, sectionPartManager, connection, selectionProvider, null);
    }

    public VisualizeAction(String text, SectionPartManager sectionPartManager, IConnectionHandle connection, ISelectionProvider selectionProvider, IMRITransformationFactory transformationFactory) {
        super(selectionProvider, text);
        this.sectionPartManager = sectionPartManager;
        this.connection = connection;
        this.transformationFactory = transformationFactory;
        this.setEnabled(false);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.numericals = this.filterForNumericalAttributeDescriptors(selection.toList());
        if (this.transformationFactory != null) {
            this.numericals = this.transformMRIs(this.numericals);
        }
        this.setEnabled(!this.numericals.isEmpty());
    }

    public List<MRI> transformMRIs(List<MRI> mris) {
        ArrayList<MRI> transformed = new ArrayList<MRI>();
        for (MRI mri : mris) {
            transformed.add(this.transformationFactory.createTransformationMRI(mri));
        }
        return transformed;
    }

    private List<MRI> filterForNumericalAttributeDescriptors(List<?> descriptors) {
        ArrayList<MRI> numericals = new ArrayList<MRI>();
        IMRIMetadataService mriMetadataService = (IMRIMetadataService)this.connection.getServiceOrNull(IMRIMetadataService.class);
        if (mriMetadataService == null) {
            return numericals;
        }
        for (Object object : descriptors) {
            if (!(object instanceof ReadOnlyMRIAttribute) || !MRIMetadataToolkit.isNumerical((IMRIMetadata)mriMetadataService.getMetadata(((ReadOnlyMRIAttribute)((Object)object)).getMRI()))) continue;
            numericals.add(((ReadOnlyMRIAttribute)((Object)object)).getMRI());
        }
        return numericals;
    }

    public void run() {
        VisualizeWizardPage wizardPage = new VisualizeWizardPage(this.sectionPartManager, this.numericals, this.connection);
        OnePageWizardDialog dialog = new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)wizardPage, RJMXUIPlugin.getDefault().getImage("add-graph-16.png"));
        dialog.open();
    }
}

