/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.attributes;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.rjmx.subscription.internal.UpdatePolicyToolkit;
import com.oracle.jmc.rjmx.ui.attributes.Messages;
import com.oracle.jmc.ui.misc.QuantityKindProposal;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdateIntervalDialog
extends InputDialog {
    public UpdateIntervalDialog(Shell parentShell, int initialValue) {
        super(parentShell, Messages.UpdateIntervalDialog_DIALOG_TITLE, Messages.UpdateIntervalDialog_DIALOG_MESSAGE, UnitLookup.MILLISECONDS.quantity((long)initialValue).interactiveFormat(), UpdateIntervalDialog.createValidator());
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        QuantityKindProposal.install((Text)this.getText(), (KindOfQuantity)UnitLookup.TIMESPAN);
        return control;
    }

    private static IInputValidator createValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                try {
                    UpdateIntervalDialog.parseInterval(newText);
                    return null;
                }
                catch (QuantityConversionException e) {
                    return e.getLocalizedMessage();
                }
            }
        };
    }

    public int getUpdateInterval() {
        try {
            return UpdateIntervalDialog.parseInterval(this.getValue());
        }
        catch (QuantityConversionException e) {
            return UpdatePolicyToolkit.getDefaultUpdateInterval();
        }
    }

    private static int parseInterval(String value) throws QuantityConversionException {
        ITypedQuantity q = UnitLookup.TIMESPAN.parseInteractive(value);
        int interval = (int)q.longValueIn((IUnit)UnitLookup.MILLISECONDS, Integer.MAX_VALUE);
        if (interval <= 0) {
            throw QuantityConversionException.tooLow((IQuantity)q, (IQuantity)UnitLookup.MILLISECONDS.quantity(1L));
        }
        return interval;
    }
}

