/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.attributes;

import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.LinearKindOfQuantity;
import com.oracle.jmc.common.unit.LinearUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.rjmx.ui.attributes.Messages;
import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.misc.QuantityKindProposal;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QuantityInputDialog
extends TitleAreaDialog {
    private final LinearKindOfQuantity kindOfQuantity;
    private ITypedQuantity<LinearUnit> quantity;
    private Text quantityText;

    public static ITypedQuantity<LinearUnit> promptForCustomUnit(Shell shell, ITypedQuantity<LinearUnit> initialQuantity) {
        QuantityInputDialog dialog = new QuantityInputDialog(shell, initialQuantity);
        return dialog.open() == 0 ? dialog.quantity : null;
    }

    public QuantityInputDialog(Shell parentShell, ITypedQuantity<LinearUnit> initialQuantity) {
        super(parentShell);
        this.kindOfQuantity = ((LinearUnit)initialQuantity.getUnit()).getContentType();
        this.quantity = initialQuantity;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.QuantityInputDialog_DIALOG_TITLE);
        Control contents = super.createContents(parent);
        contents.getShell().setSize(400, 220);
        DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
        this.setMessage(Messages.QuantityInputDialog_DIALOG_MESSAGE);
        this.setTitle(Messages.QuantityInputDialog_DIALOG_TITLE);
        this.validateInput();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout());
        Label label = new Label(dialogArea, 0);
        label.setText(Messages.QuantityInputDialog_LABEL_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.quantityText = new Text(dialogArea, 2052);
        this.quantityText.setText(this.quantity.interactiveFormat());
        QuantityKindProposal.install((Text)this.quantityText, (KindOfQuantity)this.kindOfQuantity);
        this.quantityText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuantityInputDialog.this.validateInput();
            }
        });
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 80;
        this.quantityText.setLayoutData((Object)gridData);
        return dialogArea;
    }

    private void validateInput() {
        Button okButton = this.getButton(0);
        try {
            this.quantity = this.kindOfQuantity.parseInteractive(this.quantityText.getText());
            this.setErrorMessage(null);
            okButton.setEnabled(true);
        }
        catch (QuantityConversionException e) {
            this.setErrorMessage(e.getLocalizedMessage());
            okButton.setEnabled(false);
        }
    }
}

