/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.attributes;

import com.oracle.jmc.rjmx.IConnectionHandle;
import com.oracle.jmc.rjmx.services.IAttribute;
import com.oracle.jmc.rjmx.subscription.IMRIMetadata;
import com.oracle.jmc.rjmx.subscription.IMRIMetadataProvider;
import com.oracle.jmc.rjmx.subscription.MRI;
import com.oracle.jmc.rjmx.subscription.MRIMetadataToolkit;
import com.oracle.jmc.rjmx.subscription.internal.AttributeValueToolkit;
import com.oracle.jmc.rjmx.ui.attributes.Messages;
import com.oracle.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import com.oracle.jmc.ui.misc.DialogToolkit;
import javax.management.MBeanServerConnection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class MRIAttribute
extends ReadOnlyMRIAttribute
implements IAttribute {
    protected MRIAttribute(IConnectionHandle handle, MRI mri) {
        super(handle, mri);
    }

    public void setValue(Object o) {
        try {
            AttributeValueToolkit.setAttribute((MBeanServerConnection)((MBeanServerConnection)this.getHandle().getServiceOrThrow(MBeanServerConnection.class)), (MRI)this.getMRI(), (Object)o);
            this.updateValue(o);
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.MRIAttribute_ERROR_SETTING_ATTRIBUTE_MSG, (Object)this.getMRI().getDataPath());
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)message, (Throwable)e);
        }
    }

    public static ReadOnlyMRIAttribute create(IConnectionHandle handle, MRI mri) {
        boolean editable;
        IMRIMetadata metadata = MRIMetadataToolkit.getMRIMetadata((IConnectionHandle)handle, (MRI)mri);
        boolean bl = editable = metadata != null && MRIMetadataToolkit.isWritable((IMRIMetadataProvider)metadata);
        if (editable) {
            return new MRIAttribute(handle, mri);
        }
        return new ReadOnlyMRIAttribute(handle, mri);
    }
}

