/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.rjmx.ui.attributes;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.util.TypeHandling;
import com.oracle.jmc.rjmx.services.IReadOnlyAttribute;
import com.oracle.jmc.rjmx.ui.attributes.Messages;
import com.oracle.jmc.rjmx.ui.attributes.ValueColumnLabelProvider;
import com.oracle.jmc.ui.column.ColumnBuilder;
import com.oracle.jmc.ui.column.IColumn;
import com.oracle.jmc.ui.misc.OptimisticComparator;
import com.oracle.jmc.ui.misc.TypedLabelProvider;
import java.util.Comparator;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;

public class AttributeTreeBuilder {
    public static final IMemberAccessor<Object, Object> VALUE_CELL_ACCESSOR = new IMemberAccessor<Object, Object>(){

        public Object getMember(Object o) {
            return o instanceof IReadOnlyAttribute ? ((IReadOnlyAttribute)o).getValue() : null;
        }
    };
    private static final ColumnLabelProvider NAME_LP = new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        protected String getTextTyped(IReadOnlyAttribute attr) {
            return attr.getInfo().getName();
        }

        protected String getDefaultText(Object element) {
            return element == null ? "" : element.toString();
        }

        protected String getToolTipTextTyped(IReadOnlyAttribute attr) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.AttributeInspector_NAME_COLUMN_HEADER).append(": ").append(attr.getInfo().getName()).append('\n');
            String desc = attr.getInfo().getDescription();
            if (desc != null && desc.length() > 0) {
                sb.append(Messages.AttributeInspector_DESCRIPTION_COLUMN_HEADER).append(": ").append(desc);
            }
            return sb.toString().trim();
        }
    };
    public static final IColumn NAME = new ColumnBuilder(Messages.AttributeInspector_NAME_COLUMN_HEADER, "name", NAME_LP).comparator((Comparator)new OptimisticComparator((ILabelProvider)NAME_LP)).build();
    public static final IColumn DESCRIPTION = new ColumnBuilder(Messages.AttributeInspector_DESCRIPTION_COLUMN_HEADER, "description", (ColumnLabelProvider)new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        protected String getTextTyped(IReadOnlyAttribute attr) {
            return this.getFirstRow(attr.getInfo().getDescription());
        }

        private String getFirstRow(String s) {
            if (s == null) {
                return "";
            }
            int firstRow = s.indexOf(10);
            return firstRow >= 0 ? s.substring(0, firstRow) : s;
        }

        protected String getDefaultText(Object element) {
            return element == null ? "" : element.toString();
        }
    }).build();
    public static final IColumn TYPE = new ColumnBuilder(Messages.AttributeInspector_TYPE_COLUMN_HEADER, "type", (ColumnLabelProvider)new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        protected String getTextTyped(IReadOnlyAttribute paramater) {
            return TypeHandling.simplifyType((String)paramater.getInfo().getType());
        }
    }).build();
    public static final IColumn VALUE = new ColumnBuilder(Messages.AttributeInspector_VALUE_COLUMN_HEADER, "value", VALUE_CELL_ACCESSOR).labelProvider((ColumnLabelProvider)new ValueColumnLabelProvider()).build();

    private AttributeTreeBuilder() {
        throw new RuntimeException("AttributeTreeBuilder should not be instantiated");
    }
}

