/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.wizards;

import com.oracle.jmc.ui.wizards.ExportToFileWizardPage;
import com.oracle.jmc.ui.wizards.Messages;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public abstract class ExportTreeToFileWizardPage
extends ExportToFileWizardPage {
    public static final String TREE_NAME = "wizards.importexport.tree.name";
    private ContainerCheckedTreeViewer ctw;

    public ExportTreeToFileWizardPage(String pageName, String fileExtension) {
        super(pageName, fileExtension);
    }

    protected abstract void initializeViewer(TreeViewer var1);

    private Composite createButtonContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        this.createButtonWithHandler(container, Messages.TreeContentProviderWizardPage_SELECT_ALL_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = ExportTreeToFileWizardPage.this.ctw.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    ExportTreeToFileWizardPage.this.ctw.setChecked(treeItem.getData(), true);
                    ++n2;
                }
                ExportTreeToFileWizardPage.this.updatePageComplete();
            }
        });
        this.createButtonWithHandler(container, Messages.TreeContentProviderWizardPage_DESELECT_ALL_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = ExportTreeToFileWizardPage.this.ctw.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    ExportTreeToFileWizardPage.this.ctw.setChecked(treeItem.getData(), false);
                    ++n2;
                }
                ExportTreeToFileWizardPage.this.updatePageComplete();
            }
        });
        return container;
    }

    private Control createButtonWithHandler(Composite parent, String text, SelectionListener s) {
        GridData gd1 = new GridData(4, 4, true, false);
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener(s);
        button.setLayoutData((Object)gd1);
        return button;
    }

    @Override
    protected Composite createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.ctw = new ContainerCheckedTreeViewer(container);
        this.ctw.getTree().setData("name", (Object)TREE_NAME);
        this.initializeViewer((TreeViewer)this.ctw);
        this.setPageComplete(false);
        this.ctw.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportTreeToFileWizardPage.this.updatePageComplete();
            }
        });
        Composite buttonBar = this.createButtonContainer(container);
        container.setLayout((Layout)new GridLayout(2, false));
        this.ctw.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        buttonBar.setLayoutData((Object)new GridData(4, 4, false, true));
        return container;
    }

    @Override
    protected boolean isSelectionValid() {
        Collection<?> selected = this.getSelectedItems();
        return selected != null && selected.size() > 0;
    }

    public Collection<?> getSelectedItems() {
        return Arrays.asList(this.ctw.getCheckedElements());
    }
}

