/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.rate;

import com.oracle.jmc.ui.misc.IRefreshable;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public abstract class RefreshController {
    private static final int UPDATE_INTERVAL = 50;
    private static WeakHashMap<Display, Master> MASTERS = new WeakHashMap();
    protected final Vector<IRefreshable> m_refreshables = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefreshController createGroup(Display display) {
        if (display.getThread() != Thread.currentThread()) {
            SWT.error((int)22);
        }
        Class<RefreshController> clazz = RefreshController.class;
        synchronized (RefreshController.class) {
            Master master = MASTERS.get(display);
            if (master == null) {
                master = new Master(display);
                MASTERS.put(display, master);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return new Group(master);
        }
    }

    public static RefreshController createGroup(RefreshController parent) {
        return new Group(parent);
    }

    public void add(IRefreshable refeshable) {
        this.m_refreshables.add(refeshable);
    }

    public void remove(IRefreshable refeshable) {
        this.m_refreshables.remove(refeshable);
    }

    public abstract void stop();

    public abstract void start();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        IRefreshable[] refreshables;
        Vector<IRefreshable> vector = this.m_refreshables;
        synchronized (vector) {
            refreshables = this.m_refreshables.toArray(new IRefreshable[this.m_refreshables.size()]);
        }
        IRefreshable[] iRefreshableArray = refreshables;
        int n = refreshables.length;
        int n2 = 0;
        while (n2 < n) {
            IRefreshable refreshable = iRefreshableArray[n2];
            refreshable.refresh();
            ++n2;
        }
    }

    public void clear() {
        this.m_refreshables.clear();
    }

    private static class Group
    extends RefreshController
    implements IRefreshable {
        private final RefreshController master;
        private boolean enabled;

        public Group(RefreshController master) {
            this.master = master;
        }

        @Override
        public synchronized void stop() {
            if (this.enabled) {
                this.master.remove(this);
                this.enabled = false;
            }
        }

        @Override
        public synchronized void start() {
            if (!this.enabled) {
                this.master.add(this);
                this.enabled = true;
            }
        }

        @Override
        public boolean refresh() {
            this.update();
            return true;
        }
    }

    private static class Master
    extends RefreshController {
        private final Display m_display;
        private final AtomicBoolean m_keepAlive = new AtomicBoolean();

        public Master(Display display) {
            this.m_display = display;
        }

        @Override
        public void start() {
            if (!this.m_keepAlive.getAndSet(true)) {
                this.scheduleUpdate();
            }
        }

        @Override
        public void stop() {
            this.m_keepAlive.set(false);
        }

        private void scheduleUpdate() {
            this.m_display.timerExec(50, new Runnable(){

                @Override
                public void run() {
                    if (m_keepAlive.get()) {
                        this.update();
                        this.scheduleUpdate();
                    }
                }
            });
        }

        @Override
        public void add(IRefreshable refeshable) {
            super.add(refeshable);
            this.start();
        }

        @Override
        public void remove(IRefreshable refeshable) {
            super.remove(refeshable);
            if (this.m_refreshables.isEmpty()) {
                this.stop();
            }
        }
    }
}

