/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.rate;

import com.oracle.jmc.ui.rate.RateCoordinator;

public abstract class RateLimitedRefresher
implements Runnable {
    protected final RateCoordinator rateCoordinator;
    protected final int minPeriodMillis;
    private long lastRefreshMillis;
    private boolean needsRefresh;

    public RateLimitedRefresher(RateCoordinator rateCoordinator, int minPeriodMillis) {
        this.rateCoordinator = rateCoordinator;
        this.minPeriodMillis = minPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeedsRefresh() {
        int delay = -1;
        RateLimitedRefresher rateLimitedRefresher = this;
        synchronized (rateLimitedRefresher) {
            if (!this.needsRefresh) {
                this.needsRefresh = true;
                delay = (int)Math.max(0L, this.lastRefreshMillis + (long)this.minPeriodMillis - System.currentTimeMillis());
            }
        }
        if (delay >= 0) {
            this.rateCoordinator.schedule(this, delay);
        }
    }

    @Override
    public final void run() {
        this.refreshIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIfNeeded() {
        boolean refresh = false;
        RateLimitedRefresher rateLimitedRefresher = this;
        synchronized (rateLimitedRefresher) {
            if (this.needsRefresh) {
                this.needsRefresh = false;
                refresh = true;
                this.lastRefreshMillis = System.currentTimeMillis();
            }
        }
        if (refresh) {
            this.doRefresh();
        }
    }

    protected abstract void doRefresh();
}

