/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.rate;

import com.oracle.jmc.ui.misc.IRefreshable;
import java.util.ArrayList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class RateCoordinator
implements IRefreshable {
    private final DelayQueue<Task> taskQueue = new DelayQueue();
    private long currentReferenceTime;

    public void schedule(Runnable runnable, int minDelayMillis) {
        Task task = new Task(System.currentTimeMillis() + (long)minDelayMillis, runnable);
        this.taskQueue.add(task);
    }

    @Override
    public boolean refresh() {
        this.currentReferenceTime = System.currentTimeMillis();
        if (!this.taskQueue.isEmpty()) {
            ArrayList tasks = new ArrayList(this.taskQueue.size());
            this.taskQueue.drainTo(tasks);
            for (Task task : tasks) {
                task.runnable.run();
            }
            return true;
        }
        return false;
    }

    private class Task
    implements Delayed {
        public final long scheduledTime;
        public final Runnable runnable;

        public Task(long scheduledTime, Runnable runnable) {
            this.scheduledTime = scheduledTime;
            this.runnable = runnable;
        }

        @Override
        public int compareTo(Delayed other) {
            return (int)(this.scheduledTime - ((Task)other).scheduledTime);
        }

        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.scheduledTime - RateCoordinator.this.currentReferenceTime;
        }
    }
}

