/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.preferences;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.misc.QuantityKindProposal;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class QuantityFieldEditor
extends StringFieldEditor {
    private final KindOfQuantity<?> type;
    private IQuantity min;
    private IQuantity max;

    public QuantityFieldEditor(String name, String labelText, Composite parent, KindOfQuantity<?> type) {
        this.type = type;
        this.init(name, labelText);
        this.createControl(parent);
        QuantityKindProposal.install(this.getTextControl(), type);
    }

    public void setValidRange(IQuantity min, IQuantity max) {
        if (!this.type.equals((Object)min.getType()) || !this.type.equals((Object)max.getType())) {
            throw new IllegalArgumentException(MessageFormat.format("Range limits {0} and {1} must be of kind {2}", min, max, this.type));
        }
        this.min = min;
        this.max = max;
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        try {
            this.validateQuantity((IQuantity)this.type.parseInteractive(text.getText()));
            this.clearErrorMessage();
            return true;
        }
        catch (QuantityConversionException e) {
            this.showErrorMessage(e.getLocalizedMessage());
            return false;
        }
    }

    protected void validateQuantity(IQuantity value) throws QuantityConversionException {
        if (this.min != null && this.min.compareTo((Object)value) > 0) {
            throw QuantityConversionException.tooLow((IQuantity)value, (IQuantity)this.min);
        }
        if (this.max != null && this.max.compareTo((Object)value) < 0) {
            throw QuantityConversionException.tooHigh((IQuantity)value, (IQuantity)this.max);
        }
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            String value = this.getInteractiveValue(false);
            text.setText(value);
            this.oldValue = value;
        }
        this.valueChanged();
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            text.setText(this.getInteractiveValue(true));
        }
        this.valueChanged();
    }

    private String getInteractiveValue(boolean defaultValue) {
        IQuantity value = this.doGetQuantity(defaultValue);
        return value == null ? "" : value.interactiveFormat();
    }

    protected IQuantity doGetQuantity(boolean defaultValue) {
        try {
            if (defaultValue) {
                return this.type.parsePersisted(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
            }
            return this.type.parsePersisted(this.getPreferenceStore().getString(this.getPreferenceName()));
        }
        catch (QuantityConversionException e) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load value for " + this.getPreferenceName(), e);
            return null;
        }
    }

    protected void doSetQuantity(IQuantity value) throws QuantityConversionException {
        this.getPreferenceStore().setValue(this.getPreferenceName(), value.persistableString());
    }

    protected void doStore() {
        Text text = this.getTextControl();
        try {
            if (text != null) {
                this.doSetQuantity((IQuantity)this.type.parseInteractive(text.getText()));
            }
        }
        catch (QuantityConversionException quantityConversionException) {
            // empty catch block
        }
    }
}

