/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.preferences;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.QuantityConversionException;
import com.oracle.jmc.ui.preferences.QuantityFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class LongQuantityFieldEditor
extends QuantityFieldEditor {
    private final long maxIntegerValue;
    private final IUnit storageUnit;

    public LongQuantityFieldEditor(String name, String labelText, Composite parent, IUnit storageUnit) {
        this(name, labelText, parent, storageUnit, Long.MAX_VALUE);
    }

    public LongQuantityFieldEditor(String name, String labelText, Composite parent, IUnit storageUnit, long maxIntegerValue) {
        super(name, labelText, parent, storageUnit.getContentType());
        this.storageUnit = storageUnit;
        this.maxIntegerValue = maxIntegerValue;
    }

    @Override
    protected void validateQuantity(IQuantity value) throws QuantityConversionException {
        super.validateQuantity(value);
        IQuantity valueInStoragePrecision = this.storageUnit.quantity(value.longValueIn(this.storageUnit, this.maxIntegerValue));
        if (valueInStoragePrecision.compareTo((Object)value) != 0) {
            throw QuantityConversionException.belowPrecision((IQuantity)value, (IQuantity)this.storageUnit.quantity(1L));
        }
    }

    @Override
    protected IQuantity doGetQuantity(boolean defaultValue) {
        if (defaultValue) {
            return this.storageUnit.quantity(this.getPreferenceStore().getDefaultLong(this.getPreferenceName()));
        }
        return this.storageUnit.quantity(this.getPreferenceStore().getLong(this.getPreferenceName()));
    }

    @Override
    protected void doSetQuantity(IQuantity value) throws QuantityConversionException {
        this.getPreferenceStore().setValue(this.getPreferenceName(), value.longValueIn(this.storageUnit, this.maxIntegerValue));
    }
}

