/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.misc.Messages;
import com.oracle.jmc.ui.misc.OverlayImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;

public class WarningDescriptorHelper {
    private String warningMessage = null;
    private String warningMessageLong = null;
    private final ImageDescriptor warningOverlay = UIPlugin.getDefault().getMCImageDescriptor("overlay_warning.gif");

    public String getName(String baseName) {
        return String.valueOf(baseName) + (this.warningMessage != null ? " (" + this.warningMessage + ")" : "");
    }

    public String getDescription(String baseDescription) {
        return String.valueOf(baseDescription) + (this.warningMessage != null ? " (" + this.warningMessageLong + ")" : "");
    }

    public void setWarning(String message) {
        this.warningMessage = Messages.AbstractWarningItem_WARNING;
        this.warningMessageLong = String.valueOf(Messages.AbstractWarningItem_WARNING) + ": " + message;
    }

    public void setSpecificWarning(String message) {
        this.warningMessage = message;
        this.warningMessageLong = message;
    }

    public void resetWarning() {
        this.warningMessage = null;
        this.warningMessageLong = null;
    }

    public ImageDescriptor getImageDescriptor(ImageDescriptor baseImageDescriptor) {
        return new OverlayImageDescriptor(baseImageDescriptor, false, this.warningMessage == null ? null : this.warningOverlay);
    }
}

