/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.idesupport.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbench;

public class TrayManager {
    private final IWorkbench m_workBench;
    private TrayItem m_trayItem;
    private Menu m_menu;

    public TrayManager(IWorkbench workbench) {
        this.m_workBench = workbench;
    }

    private Shell getWorkbenchShell() {
        return this.m_workBench.getActiveWorkbenchWindow().getShell();
    }

    public void dispose() {
        this.destroyTip();
        this.destroyTrayItem();
        this.destroyMenu();
    }

    private void destroyTip() {
        ToolTip tip;
        if (this.m_trayItem != null && (tip = this.m_trayItem.getToolTip()) != null && !tip.isDisposed()) {
            tip.dispose();
        }
    }

    private void destroyTrayItem() {
        if (this.m_trayItem != null && !this.m_trayItem.isDisposed()) {
            this.m_trayItem.dispose();
            this.m_trayItem = null;
        }
    }

    private void destroyMenu() {
        if (this.m_menu != null) {
            this.m_menu.dispose();
            this.m_menu = null;
        }
    }

    public void showTooltip(String title, String message, int style) {
        if (this.m_trayItem != null) {
            this.createTip(this.m_trayItem, title, message, style);
        }
    }

    public boolean minimizeToTray() {
        Tray tray = this.getWorkbenchShell().getDisplay().getSystemTray();
        if (tray != null) {
            this.m_trayItem = this.createTrayItem(tray);
            this.hideShell();
            return true;
        }
        return false;
    }

    public boolean isTraySupported() {
        return this.getWorkbenchShell().getDisplay().getSystemTray() != null;
    }

    public void maximizeFromTray() {
        this.showShell();
        this.destroyTip();
        this.destroyMenu();
        this.destroyTrayItem();
    }

    public void setMinimizeToTrayOnClose(boolean minimizeOnClose) {
        UIPlugin.getDefault().getPreferenceStore().setValue("tray.minimize.on.close", minimizeOnClose);
    }

    public boolean getMinimizeToTrayOnClose() {
        return UIPlugin.getDefault().getPreferenceStore().getBoolean("tray.minimize.on.close");
    }

    private TrayItem createTrayItem(Tray tray) {
        this.destroyTrayItem();
        TrayItem trayItem = new TrayItem(this.getWorkbenchShell().getDisplay().getSystemTray(), 0);
        trayItem.setImage(UIPlugin.getDefault().getImage("mission_control.gif"));
        trayItem.setToolTipText(Messages.TrayManager_JROCKIT_MISSION_CONTROL_TEXT);
        trayItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TrayManager.this.maximizeFromTray();
            }
        });
        trayItem.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                TrayManager.this.showPoupMenu();
            }
        });
        return trayItem;
    }

    private void showPoupMenu() {
        if (this.m_menu == null) {
            this.m_menu = this.createPopupMenu();
        }
        this.m_menu.setVisible(true);
    }

    private void createTip(TrayItem item, String title, String message, int style) {
        this.destroyTip();
        Shell s = new Shell();
        ToolTip tip = new ToolTip(s, style);
        tip.setMessage(message);
        tip.setText(title);
        tip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrayManager.this.maximizeFromTray();
            }
        });
        item.setToolTip(tip);
        tip.setVisible(true);
    }

    private Menu createPopupMenu() {
        this.destroyMenu();
        Menu menu = new Menu((Decorations)this.getWorkbenchShell(), 8);
        MenuItem exit = new MenuItem(menu, 8);
        exit.setText(Messages.TrayManager_EXIT_MENU_ACTION_TEXT);
        exit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TrayManager.this.destroyTrayItem();
                TrayManager.this.destroyMenu();
                TrayManager.this.getWorkbench().close();
            }
        });
        MenuItem open = new MenuItem(menu, 8);
        open.setText(Messages.TrayManager_OPEN_MENU_ITEM_TEXT);
        open.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TrayManager.this.destroyMenu();
                TrayManager.this.maximizeFromTray();
            }
        });
        return menu;
    }

    private IWorkbench getWorkbench() {
        return this.m_workBench;
    }

    private void showShell() {
        this.getWorkbenchShell().setVisible(true);
        this.getWorkbenchShell().setActive();
        this.getWorkbenchShell().setFocus();
        this.getWorkbenchShell().setMinimized(false);
    }

    private void hideShell() {
        this.getWorkbenchShell().setVisible(false);
    }
}

