/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.ui.UIPlugin;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jface.viewers.ILabelProvider;

public class OptimisticComparator
implements Comparator<Object> {
    private final IMemberAccessor<?, Object> cellAccessor;
    private final ILabelProvider labelProvider;

    public OptimisticComparator(ILabelProvider labelProviderForRow) {
        this(null, labelProviderForRow);
    }

    public OptimisticComparator(IMemberAccessor<?, Object> cellAccessor, ILabelProvider labelProviderForRow) {
        this.cellAccessor = cellAccessor;
        this.labelProvider = labelProviderForRow;
    }

    @Override
    public int compare(Object row1, Object row2) {
        Object cellOrRow2;
        Object cellOrRow1;
        if (this.cellAccessor == null) {
            cellOrRow1 = row1;
            cellOrRow2 = row2;
        } else {
            cellOrRow1 = this.cellAccessor.getMember(row1);
            cellOrRow2 = this.cellAccessor.getMember(row2);
        }
        if (cellOrRow1 instanceof Comparable) {
            if (cellOrRow2 instanceof Comparable) {
                Class<?> class1 = cellOrRow1.getClass();
                Class<?> class2 = cellOrRow2.getClass();
                if (!Objects.equals(class1.getClassLoader(), class2.getClassLoader())) {
                    int clCompare = Integer.compare(System.identityHashCode(class1.getClassLoader()), System.identityHashCode(class2.getClassLoader()));
                    if (clCompare == 0) {
                        UIPlugin.getDefault().getLogger().severe(class1.getClassLoader() + " and " + class2.getClassLoader() + " are different but has the same hash code");
                        return this.compareLabels(row1, row2);
                    }
                    return clCompare;
                }
                if (class1.equals(class2)) {
                    return this.compareComparable((Comparable)cellOrRow1, (Comparable)cellOrRow2);
                }
                return cellOrRow1.getClass().getCanonicalName().compareTo(cellOrRow2.getClass().getCanonicalName());
            }
            return 1;
        }
        return cellOrRow2 instanceof Comparable ? -1 : this.compareLabels(row1, row2);
    }

    private int compareComparable(Comparable<?> o1, Comparable<?> o2) {
        return o1.compareTo(o2);
    }

    private int compareLabels(Object row1, Object row2) {
        if (this.labelProvider != null) {
            String l1 = this.labelProvider.getText(row1);
            String l2 = this.labelProvider.getText(row2);
            return l1 == null ? (l2 == null ? 0 : -1) : (l2 == null ? 1 : l1.compareTo(l2));
        }
        return 0;
    }
}

