/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class MCLayoutFactory {
    public static final int DEFAULT_LAYOUT_DATA_WIDTH = 50;
    public static final int DEFAULT_LAYOUT_DATA_HEIGHT = 50;
    public static final int VERTICAL_SECTION_SPACING = 6;
    public static final int HORIZONTAL_SECTION_SPACING = 6;
    public static final int MANAGED_FORM_MARGIN_WIDTH = 6;
    public static final int MANAGED_FORM_MARGIN_HEIGHT = 6;

    public static Layout createFormPageLayout() {
        return MCLayoutFactory.createFormPageLayout(6, 6);
    }

    public static Layout createFormPageLayout(int marginW, int marginH) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = marginW;
        layout.marginHeight = marginH;
        layout.verticalSpacing = 6;
        layout.horizontalSpacing = 6;
        return layout;
    }

    public static Layout createMarginFreeFormPageLayout(int horizontalspan) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 6;
        layout.horizontalSpacing = 6;
        layout.numColumns = horizontalspan;
        return layout;
    }

    public static Layout createPaintBordersMarginFreeFormPageLayout(int horizontalspan) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.verticalSpacing = 6;
        layout.horizontalSpacing = 6;
        layout.numColumns = horizontalspan;
        return layout;
    }

    public static Layout createMarginFreeFormPageLayout() {
        return MCLayoutFactory.createMarginFreeFormPageLayout(1);
    }

    public static Layout createFormPageLayout(int columns) {
        GridLayout l = (GridLayout)MCLayoutFactory.createFormPageLayout();
        l.numColumns = columns;
        return l;
    }

    public static GridLayout createPackedLayout(int numColumns, boolean makeColumnsEqualWidth) {
        GridLayout layout = new GridLayout(numColumns, makeColumnsEqualWidth);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    public static Object createFormPageLayoutData() {
        return MCLayoutFactory.createFormPageLayoutData(50, 50, 1, 1, true, true);
    }

    public static Object createFormPageLayoutData(int widthHint, int heightHint, int horizontalSpan, int vererticalSpan, boolean grabExcessiveHorizontal, boolean grabExcessiveVertical) {
        GridData layoutData = (GridData)MCLayoutFactory.createFormPageLayoutData(widthHint, heightHint, grabExcessiveHorizontal, grabExcessiveVertical);
        layoutData.widthHint = widthHint;
        layoutData.heightHint = heightHint;
        layoutData.horizontalSpan = horizontalSpan;
        layoutData.verticalSpan = vererticalSpan;
        return layoutData;
    }

    public static Object createFormPageLayoutData(int widthHint, int heightHint, boolean grabExcessiveWidth, boolean grabExcessiveHeight) {
        GridData layoutData = new GridData(4, 4, grabExcessiveWidth, grabExcessiveHeight);
        layoutData.widthHint = widthHint;
        layoutData.heightHint = heightHint;
        return layoutData;
    }

    public static Object createFormPageLayoutData(int horisontalAlignment, int verticalAlignment, int widthHint, int heightHint) {
        GridData layoutData = new GridData(horisontalAlignment, verticalAlignment, false, false);
        layoutData.widthHint = widthHint;
        layoutData.heightHint = heightHint;
        return layoutData;
    }

    public static Object createFormPageLayoutData(int columns, int rows) {
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 50;
        layoutData.heightHint = 50;
        layoutData.horizontalSpan = columns;
        layoutData.verticalSpan = rows;
        return layoutData;
    }

    public static void addGrabOnExpandLayoutData(Section section) {
        final GridData gd = new GridData(4, 4, true, section.isExpanded());
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                gd.grabExcessVerticalSpace = Boolean.TRUE.equals(e.data);
            }
        });
        section.setLayoutData((Object)gd);
    }
}

