/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.ui.misc.Messages;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class IntFieldEditor
extends IntegerFieldEditor {
    private int minOkValue = 0;
    private int maxOkValue = Integer.MAX_VALUE;
    private String generatedErrorMsg;

    public IntFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setErrorMessage(null);
    }

    public IntFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        super(name, labelText, parent, textLimit);
        this.setErrorMessage(null);
    }

    public void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
    }

    public void setValidRange(int min, int max) {
        this.minOkValue = min;
        this.maxOkValue = max;
        String overriddenErrorMsg = this.getErrorMessage();
        super.setValidRange(min, max);
        this.setErrorMessage(overriddenErrorMsg);
        this.generatedErrorMsg = null;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.getErrorMessage());
    }

    public String getErrorMessage() {
        String valueName;
        boolean hasMin;
        String msg = super.getErrorMessage();
        if (msg != null) {
            return msg;
        }
        if (this.generatedErrorMsg != null) {
            return this.generatedErrorMsg;
        }
        boolean hasMax = this.maxOkValue != Integer.MAX_VALUE;
        boolean bl = hasMin = this.minOkValue != Integer.MIN_VALUE;
        if (this.minOkValue == 0) {
            valueName = Messages.IntFieldEditor_ERROR_MESSAGE_PART_POSITIVE_INTEGER;
            hasMin = false;
        } else if (this.minOkValue == 1) {
            valueName = Messages.IntFieldEditor_ERROR_MESSAGE_PART_NATURAL_NUMBER;
            hasMin = false;
        } else if (this.maxOkValue == 0) {
            valueName = Messages.IntFieldEditor_ERROR_MESSAGE_PART_NEGATIVE_INTEGER;
            hasMax = false;
        } else {
            valueName = Messages.IntFieldEditor_ERROR_MESSAGE_PART_INTEGER;
        }
        Object[] msgArgs = new Object[]{valueName, this.minOkValue, this.maxOkValue};
        msg = hasMax && hasMin ? NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_INTERVAL, (Object[])msgArgs) : (hasMax && !hasMin ? NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_NO_GREATER, (Object[])msgArgs) : (!hasMax && hasMin ? NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_NO_SMALLER, (Object[])msgArgs) : NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_MUST_BE, (Object[])msgArgs)));
        this.generatedErrorMsg = msg;
        return this.generatedErrorMsg;
    }
}

