/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.ui.misc.CopySettings;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public class FormatToolkit {
    private static final String CRLF = "\r\n";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private static final String SEMI_COLON = ";";
    private static final String QUOTE = "\"";
    private static final String DOUBLE_QUOTE = "\"\"";
    private static final String SPACE_INDENT = "   ";

    public static Function<Stream<String>, String> getPreferredRowFormatter() {
        return CopySettings.getInstance().shouldCopyAsCsv() ? FormatToolkit::formatRowCsv : FormatToolkit::formatRow;
    }

    public static String formatRow(Stream<String> cells) {
        return String.valueOf(cells.collect(Collectors.joining(TAB))) + LINE_SEPARATOR;
    }

    public static String formatRowCsv(Stream<String> cells) {
        return String.valueOf(cells.map(str -> QUOTE + str.replaceAll(QUOTE, DOUBLE_QUOTE) + QUOTE).collect(Collectors.joining(SEMI_COLON))) + CRLF;
    }

    public static Function<IStructuredSelection, Stream<String>> selectionFormatter(ILabelProvider ... lps) {
        return selection -> {
            Function<Stream<String>, String> rowFormatter = FormatToolkit.getPreferredRowFormatter();
            Function<Object, String> objectFormatter = o -> (String)rowFormatter.apply(Stream.of(lps).map(lp -> lp.getText(o)));
            return FormatToolkit.formatSelection(selection, objectFormatter);
        };
    }

    public static Stream<String> formatSelection(IStructuredSelection selection, Function<Object, String> objectFormatter) {
        if (selection instanceof ITreeSelection) {
            if (CopySettings.getInstance().shouldIndentForStructure()) {
                Stream.Builder<String> builder = Stream.builder();
                TreePath[] treePathArray = ((ITreeSelection)selection).getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray[n2];
                    int indents = path.getSegmentCount() - 1;
                    int n3 = 0;
                    while (n3 < indents) {
                        builder.accept(SPACE_INDENT);
                        ++n3;
                    }
                    builder.accept(objectFormatter.apply(path.getLastSegment()));
                    ++n2;
                }
                return builder.build();
            }
            return Stream.of(((ITreeSelection)selection).getPaths()).map(TreePath::getLastSegment).map(objectFormatter);
        }
        List list = selection.toList();
        return list.stream().map(objectFormatter);
    }
}

