/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.ui.misc.TreeViewerWithPublicGetViewerRowFromItem;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FocusCellOwnerDrawHighlighterBUG268135
extends FocusCellOwnerDrawHighlighter {
    public FocusCellOwnerDrawHighlighterBUG268135(ColumnViewer viewer) {
        super(viewer);
        this.hookFixedListener(viewer);
    }

    private void markFocusedCell(Event event, ViewerCell cell) {
        Color foreground;
        Color background = cell.getControl().isFocusControl() ? this.getSelectedCellBackgroundColor(cell) : this.getSelectedCellBackgroundColorNoFocus(cell);
        Color color = foreground = cell.getControl().isFocusControl() ? this.getSelectedCellForegroundColor(cell) : this.getSelectedCellForegroundColorNoFocus(cell);
        if (foreground != null || background != null || this.onlyTextHighlighting(cell)) {
            GC gc = event.gc;
            if (background == null) {
                background = cell.getItem().getDisplay().getSystemColor(26);
            }
            if (foreground == null) {
                foreground = cell.getItem().getDisplay().getSystemColor(27);
            }
            gc.setBackground(background);
            gc.setForeground(foreground);
            if (this.onlyTextHighlighting(cell)) {
                Rectangle area = event.getBounds();
                Rectangle rect = cell.getTextBounds();
                if (rect != null) {
                    area.x = rect.x;
                }
                gc.fillRectangle(area);
            } else {
                gc.fillRectangle(event.getBounds());
            }
            event.detail &= 0xFFFFFFFD;
        }
    }

    private void hookFixedListener(final ColumnViewer viewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) != 0 && viewer instanceof TreeViewerWithPublicGetViewerRowFromItem) {
                    ViewerCell focusCell = FocusCellOwnerDrawHighlighterBUG268135.this.getFocusCell();
                    ViewerRow row = ((TreeViewerWithPublicGetViewerRowFromItem)viewer).getViewerRowFromItem(event.item);
                    ViewerCell cell = row.getCell(event.index);
                    if (focusCell != null && cell.equals((Object)focusCell)) {
                        FocusCellOwnerDrawHighlighterBUG268135.this.markFocusedCell(event, cell);
                    }
                }
            }
        };
        Listener[] listenerArray = viewer.getControl().getListeners(40);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener oldListener = listenerArray[n2];
            viewer.getControl().removeListener(40, oldListener);
            ++n2;
        }
        viewer.getControl().addListener(40, listener);
    }

    protected Color getSelectedCellBackgroundColor(ViewerCell cell) {
        return cell.getItem().getDisplay().getSystemColor(26);
    }
}

