/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.item.ICanonicalAccessorFactory;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.item.PersistableItemFilter;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.RangeContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.ui.TypeAppearance;
import com.oracle.jmc.ui.UIPlugin;
import com.oracle.jmc.ui.accessibility.FocusTracker;
import com.oracle.jmc.ui.celleditors.CommonCellEditors;
import com.oracle.jmc.ui.handlers.ActionToolkit;
import com.oracle.jmc.ui.handlers.InFocusHandlerActivator;
import com.oracle.jmc.ui.handlers.MCContextMenuManager;
import com.oracle.jmc.ui.misc.AbstractStructuredContentProvider;
import com.oracle.jmc.ui.misc.ClipboardManager;
import com.oracle.jmc.ui.misc.ControlDecorationToolkit;
import com.oracle.jmc.ui.misc.DelegatingLabelProvider;
import com.oracle.jmc.ui.misc.DndToolkit;
import com.oracle.jmc.ui.misc.FocusCellOwnerDrawHighlighterBUG268135;
import com.oracle.jmc.ui.misc.Messages;
import com.oracle.jmc.ui.misc.SWTColorToolkit;
import com.oracle.jmc.ui.misc.TreeViewerWithPublicGetViewerRowFromItem;
import com.oracle.jmc.ui.misc.TypedLabelProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FilterEditor {
    private static final PersistableItemFilter.Kind[] EQUALS_OPERATIONS = new PersistableItemFilter.Kind[]{PersistableItemFilter.Kind.EQUALS, PersistableItemFilter.Kind.NOT_EQUALS, PersistableItemFilter.Kind.EXISTS, PersistableItemFilter.Kind.NOT_EXISTS, PersistableItemFilter.Kind.IS_NULL, PersistableItemFilter.Kind.IS_NOT_NULL};
    private static final PersistableItemFilter.Kind[] COMPARE_OPERATIONS = new PersistableItemFilter.Kind[]{PersistableItemFilter.Kind.EQUALS, PersistableItemFilter.Kind.NOT_EQUALS, PersistableItemFilter.Kind.LESS, PersistableItemFilter.Kind.LESS_OR_EQUAL, PersistableItemFilter.Kind.MORE, PersistableItemFilter.Kind.MORE_OR_EQUAL, PersistableItemFilter.Kind.EXISTS, PersistableItemFilter.Kind.NOT_EXISTS, PersistableItemFilter.Kind.IS_NULL, PersistableItemFilter.Kind.IS_NOT_NULL};
    private static final PersistableItemFilter.Kind[] STRING_OPERATIONS = new PersistableItemFilter.Kind[]{PersistableItemFilter.Kind.EQUALS, PersistableItemFilter.Kind.NOT_EQUALS, PersistableItemFilter.Kind.LESS, PersistableItemFilter.Kind.LESS_OR_EQUAL, PersistableItemFilter.Kind.MORE, PersistableItemFilter.Kind.MORE_OR_EQUAL, PersistableItemFilter.Kind.MATCHES, PersistableItemFilter.Kind.NOT_MATCHES, PersistableItemFilter.Kind.CONTAINS, PersistableItemFilter.Kind.NOT_CONTAINS, PersistableItemFilter.Kind.EXISTS, PersistableItemFilter.Kind.NOT_EXISTS, PersistableItemFilter.Kind.IS_NULL, PersistableItemFilter.Kind.IS_NOT_NULL};
    private static final PersistableItemFilter.Kind[] RANGE_OPERATIONS = new PersistableItemFilter.Kind[]{PersistableItemFilter.Kind.RANGE_CONTAINED, PersistableItemFilter.Kind.RANGE_INTERSECTS, PersistableItemFilter.Kind.CENTER_CONTAINED};
    private static final List<PersistableItemFilter.Kind> REGEX_OPERATIONS = Arrays.asList(PersistableItemFilter.Kind.MATCHES, PersistableItemFilter.Kind.NOT_MATCHES, PersistableItemFilter.Kind.CONTAINS, PersistableItemFilter.Kind.NOT_CONTAINS);
    private final TreeViewer tree;
    private final CompositeNode root = new CompositeNode(Stream.empty(), false, false);
    private final Consumer<IItemFilter> onChange;
    private final MCContextMenuManager mm;
    private final Supplier<Collection<IAttribute<?>>> attributeSupplier;
    private Collection<IAttribute<?>> attributes;
    private final AttributeValueProvider attributeValueProvider;

    public <M> FilterEditor(Composite parent, Consumer<IItemFilter> onChange, IItemFilter initial, Supplier<Collection<IAttribute<?>>> attributeSupplier, AttributeValueProvider attributeValueProvider, Function<String, Color> typeColorProvider, int style) {
        this.attributeSupplier = attributeSupplier;
        this.attributeValueProvider = attributeValueProvider;
        this.tree = new TreeViewerWithPublicGetViewerRowFromItem(parent, 0x10302 | style);
        this.onChange = onChange;
        this.tree.setContentProvider((IContentProvider)new FilterArrayContentProvider());
        FocusTracker.enableFocusTracking((Composite)this.tree.getTree());
        this.initializeCellFocus();
        FilterEditor.addColumn(this.tree, 150, new NameLabelProvider(typeColorProvider), new AttributeEditingSupport((ColumnViewer)this.tree));
        FilterEditor.addColumn(this.tree, 100, new OperationLabelProvider(), new OperationEditingSupport((ColumnViewer)this.tree));
        FilterEditor.addColumn(this.tree, 500, new ValueLabelProvider(), new ValueEditingSupport((ColumnViewer)this.tree));
        this.mm = MCContextMenuManager.create(this.tree.getControl());
        this.mm.appendToGroup("group.new", ActionToolkit.forListSelection((StructuredViewer)this.tree, Messages.FilterEditor_ACTION_COMBINE_OR, false, this.forNonEmptyFilterSelection(filters -> {
            Set<Object> expanded = this.asSet(this.tree.getExpandedElements());
            expanded.add(FilterNodeToolkit.wrapFilters(this.root, filters, true));
            this.tree.setInput((Object)this.root);
            this.tree.setExpandedElements(expanded.toArray());
        })));
        this.mm.appendToGroup("group.new", ActionToolkit.forListSelection((StructuredViewer)this.tree, Messages.FilterEditor_ACTION_COMBINE_AND, false, this.forNonEmptyFilterSelection(filters -> {
            Set<Object> expanded = this.asSet(this.tree.getExpandedElements());
            expanded.add(FilterNodeToolkit.wrapFilters(this.root, filters, false));
            this.tree.setInput((Object)this.root);
            this.tree.setExpandedElements(expanded.toArray());
        })));
        this.mm.appendToGroup("group.new", ActionToolkit.forListSelection((StructuredViewer)this.tree, Messages.FilterEditor_ACTION_REMOVE, false, selection -> this.onlyCompositeNodesSelected((List<FilterNode>)selection) ? () -> {
            Object[] expanded = this.tree.getExpandedElements();
            for (FilterNode node : selection) {
                FilterNodeToolkit.unwrapFilter(this.root, (CompositeNode)node);
            }
            this.tree.setInput((Object)this.root);
            this.tree.setExpandedElements(expanded);
        } : null));
        this.mm.appendToGroup("group.new", ActionToolkit.forListSelection((StructuredViewer)this.tree, Messages.FilterEditor_ACTION_NEGATE, true, filters -> this.filtersNegatable((List<FilterNode>)filters) ? () -> {
            for (FilterNode filter : filters) {
                if (filter instanceof CompositeNode) {
                    CompositeNode composite = (CompositeNode)filter;
                    composite.negated = !composite.negated;
                    continue;
                }
                if (!FilterEditor.isAttributeFilter(filter)) continue;
                ItemFilters.AttributeFilter attributeFilter = FilterEditor.asAttributeFilterM(filter);
                Object value = attributeFilter instanceof ItemFilters.AttributeValue ? ((ItemFilters.AttributeValue)attributeFilter).getValue() : null;
                PersistableItemFilter.Kind kind = attributeFilter.getKind();
                PersistableItemFilter.Kind newKind = kind.negate();
                if (newKind == null) continue;
                ((LeafNode)filter).filter = FilterEditor.buildFilter(newKind, attributeFilter.getAttribute(), value);
            }
            this.notifyListener();
        } : null));
        IAction cutAction = ActionToolkit.forListSelection((StructuredViewer)this.tree, null, false, this.forNonEmptyFilterSelection(this::cutNodes));
        ActionToolkit.convertToCommandAction(cutAction, "org.eclipse.ui.edit.cut");
        InFocusHandlerActivator.install(this.tree.getControl(), cutAction);
        this.mm.appendToGroup("group.edit", cutAction);
        IAction copyAction = ActionToolkit.forListSelection((StructuredViewer)this.tree, null, false, this.forNonEmptyFilterSelection(this::copyNodes));
        ActionToolkit.convertToCommandAction(copyAction, "org.eclipse.ui.edit.copy");
        InFocusHandlerActivator.install(this.tree.getControl(), copyAction);
        this.mm.appendToGroup("group.edit", copyAction);
        IAction pasteAction = ActionToolkit.forListSelection((StructuredViewer)this.tree, null, false, selection -> selection.size() <= 1 ? () -> this.pasteNodes((List<FilterNode>)selection) : null);
        ActionToolkit.convertToCommandAction(pasteAction, "org.eclipse.ui.edit.paste");
        InFocusHandlerActivator.install(this.tree.getControl(), pasteAction);
        this.mm.appendToGroup("group.edit", pasteAction);
        IAction removeAction = ActionToolkit.forTreeSelection((AbstractTreeViewer)this.tree, null, false, selection -> selection.isEmpty() || selection.getFirstElement() instanceof EmptyNode ? null : () -> this.deleteNodes((ITreeSelection)selection));
        ActionToolkit.convertToCommandAction(removeAction, "org.eclipse.ui.edit.delete");
        InFocusHandlerActivator.install(this.tree.getControl(), removeAction);
        this.mm.appendToGroup("group.edit", removeAction);
        this.mm.appendToGroup("group.edit", ActionToolkit.action(this::clearNodes, Messages.FilterEditor_ACTION_CLEAR_ALL));
        if (initial instanceof ItemFilters.Composite && !((ItemFilters.Composite)initial).isUnion()) {
            IItemFilter[] iItemFilterArray = ((ItemFilters.Composite)initial).getFilters();
            int n = iItemFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IItemFilter f = iItemFilterArray[n2];
                this.root.children.add(FilterEditor.buildTreeNode(f));
                ++n2;
            }
        } else if (initial != null) {
            this.root.children.add(FilterEditor.buildTreeNode(initial));
        }
        Transfer[] localTransfer = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.tree.addDragSupport(3, localTransfer, DndToolkit.createLocalDragSource((AbstractTreeViewer)this.tree, this::deleteNodes));
        ViewerDropAdapter dropTarget = DndToolkit.createLocalDropListTarget((Viewer)this.tree, CompositeNode.class, FilterNode.class, this::performDrop, this::validateDrop);
        dropTarget.setFeedbackEnabled(false);
        this.tree.addDropSupport(3, localTransfer, (DropTargetListener)dropTarget);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tree);
        this.tree.setInput((Object)this.root);
    }

    private void initializeCellFocus() {
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(this.tree, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighterBUG268135((ColumnViewer)this.tree));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tree){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 2 && ((MouseEvent)event.sourceEvent).button == 1 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        int feature = 122;
        TreeViewerEditor.create((TreeViewer)this.tree, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)feature);
        this.tree.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (FilterEditor.this.tree.getSelection().isEmpty()) {
                    FilterEditor.this.tree.setSelection((ISelection)new StructuredSelection(FilterEditor.this.tree.getTree().getItem(0).getData()));
                }
            }
        });
    }

    public TreeViewer getTree() {
        return this.tree;
    }

    private Function<List<FilterNode>, Runnable> forNonEmptyFilterSelection(Consumer<List<FilterNode>> action) {
        return selection -> selection.isEmpty() || selection.get(0) instanceof EmptyNode ? null : () -> action.accept((List<FilterNode>)selection);
    }

    private boolean filtersNegatable(List<FilterNode> filters) {
        for (FilterNode filter : filters) {
            PersistableItemFilter.Kind kind;
            if (!(FilterEditor.isAttributeFilter(filter) ? (kind = FilterEditor.asAttributeFilter(filter).getKind()).negate() == null : !(filter instanceof CompositeNode))) continue;
            return false;
        }
        return filters.size() > 0;
    }

    private Set<Object> asSet(Object[] expandedElements) {
        HashSet<Object> set = new HashSet<Object>();
        Collections.addAll(set, expandedElements);
        return set;
    }

    private boolean onlyCompositeNodesSelected(List<FilterNode> selection) {
        for (FilterNode filter : selection) {
            if (filter instanceof CompositeNode) continue;
            return false;
        }
        return selection.size() > 0;
    }

    public MCContextMenuManager getContextMenu() {
        return this.mm;
    }

    public Control getControl() {
        return this.tree.getControl();
    }

    private static void addColumn(TreeViewer tree, int width, ColumnLabelProvider lp, EditingSupport es) {
        TreeViewerColumn nameCol = new TreeViewerColumn(tree, 0);
        nameCol.setLabelProvider((CellLabelProvider)lp);
        nameCol.setEditingSupport(es);
        nameCol.getColumn().setWidth(width);
    }

    public void notifyListener() {
        this.onChange.accept(this.getFilter());
    }

    public IItemFilter getFilter() {
        return this.root.buildFilter();
    }

    public void addRoot(IItemFilter filter) {
        this.root.children.add(FilterEditor.buildTreeNode(filter));
        this.tree.refresh();
        this.notifyListener();
    }

    private int validateDrop(List<? extends FilterNode> src, CompositeNode target, int operation) {
        if (target == null ? this.root.children.containsAll(src) : target.children.containsAll(src)) {
            return 0;
        }
        if (FilterEditor.find(target, src)) {
            return 0;
        }
        return operation;
    }

    private static boolean find(CompositeNode needle, List<? extends FilterNode> inHaystack) {
        for (FilterNode filterNode : inHaystack) {
            if (filterNode == needle) {
                return true;
            }
            if (!(filterNode instanceof CompositeNode)) continue;
            return FilterEditor.find(needle, ((CompositeNode)filterNode).children);
        }
        return false;
    }

    private boolean performDrop(List<? extends FilterNode> src, CompositeNode target, int operation, int location) {
        if (target == null) {
            target = this.root;
        }
        src.stream().map(FilterNode::copy).forEach(target.children::add);
        this.tree.refresh((Object)target);
        this.notifyListener();
        return true;
    }

    private void cutNodes(List<FilterNode> filters) {
        Object[] expanded = this.tree.getExpandedElements();
        this.copyNodes(filters);
        FilterNodeToolkit.deleteFilters(this.root, filters);
        this.tree.setInput((Object)this.root);
        this.tree.setExpandedElements(expanded);
        this.notifyListener();
    }

    private void copyNodes(List<FilterNode> filters) {
        FilterNode[] nodes = filters.toArray(new FilterNode[filters.size()]);
        ClipboardManager.setClipboardContents(new Object[]{nodes}, new Transfer[]{ClipboardManager.getClipboardLocalTransfer()});
    }

    private void pasteNodes(List<FilterNode> selection) {
        int insertIndex;
        CompositeNode insertNode;
        FilterNode selectedNode;
        FilterNode[] nodes = (FilterNode[])ClipboardManager.getClipboardContents(ClipboardManager.getClipboardLocalTransfer());
        if (nodes == null) {
            return;
        }
        Set<Object> expanded = this.asSet(this.tree.getExpandedElements());
        FilterNode filterNode = selectedNode = selection.isEmpty() ? null : selection.get(0);
        if (selectedNode == null || selectedNode instanceof EmptyNode) {
            insertNode = this.root;
            insertIndex = this.root.children.size();
        } else if (selectedNode instanceof CompositeNode) {
            insertNode = (CompositeNode)selectedNode;
            insertIndex = insertNode.children.size();
            expanded.add(insertNode);
        } else {
            insertNode = FilterNodeToolkit.getParent(selectedNode, this.root);
            insertIndex = FilterNodeToolkit.getPosition(selectedNode, insertNode) + 1;
        }
        FilterNode[] filterNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            FilterNode node = filterNodeArray[n2];
            insertNode.children.add(insertIndex++, node.copy());
            ++n2;
        }
        this.tree.setInput((Object)this.root);
        this.tree.setExpandedElements(expanded.toArray());
        this.notifyListener();
    }

    private void deleteNodes(ITreeSelection selectedNodes) {
        TreePath[] treePathArray = selectedNodes.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            int segmentCount = path.getSegmentCount();
            if (segmentCount < 2) {
                this.root.children.remove(path.getLastSegment());
            } else {
                ((CompositeNode)path.getSegment((int)(segmentCount - 2))).children.remove(path.getSegment(segmentCount - 1));
            }
            ++n2;
        }
        this.tree.refresh();
        this.notifyListener();
    }

    private void clearNodes() {
        this.root.children.clear();
        this.tree.setInput((Object)this.root);
        this.notifyListener();
    }

    private PersistableItemFilter.Kind[] getApplicableOperations(ContentType<?> ct) {
        if (ct.equals((Object)UnitLookup.PLAIN_TEXT)) {
            return STRING_OPERATIONS;
        }
        if (ct instanceof RangeContentType) {
            return RANGE_OPERATIONS;
        }
        if (ct instanceof KindOfQuantity) {
            return COMPARE_OPERATIONS;
        }
        return EQUALS_OPERATIONS;
    }

    private static void validateRegex(String regex, ControlDecoration errorDecorator) {
        try {
            Pattern.compile(regex);
            errorDecorator.hide();
        }
        catch (PatternSyntaxException ex) {
            errorDecorator.setDescriptionText(NLS.bind((String)Messages.FilterEditor_INVALID_REGEX, (Object)ex.getLocalizedMessage()));
            errorDecorator.show();
        }
    }

    private static FilterNode buildTreeNode(IItemFilter filter) {
        return FilterEditor.buildTreeNode(filter, false);
    }

    private static FilterNode buildTreeNode(IItemFilter filter, boolean negate) {
        if (filter instanceof ItemFilters.Not) {
            return FilterEditor.buildTreeNode(((ItemFilters.Not)filter).getFilter(), !negate);
        }
        if (filter instanceof ItemFilters.Composite) {
            ItemFilters.Composite cf = (ItemFilters.Composite)filter;
            return new CompositeNode(Stream.of(cf.getFilters()).map(FilterEditor::buildTreeNode), cf.isUnion(), negate);
        }
        return new LeafNode(filter);
    }

    private static <V> IItemFilter buildFilter(PersistableItemFilter.Kind comparisonKind, ICanonicalAccessorFactory<V> attribute, V value) {
        ContentType contentType = attribute.getContentType();
        if (contentType.equals(UnitLookup.PLAIN_TEXT)) {
            ICanonicalAccessorFactory<V> stringAttribute = attribute;
            return ItemFilters.buildStringFilter((PersistableItemFilter.Kind)comparisonKind, stringAttribute, (String)((String)value));
        }
        if (contentType instanceof KindOfQuantity) {
            ICanonicalAccessorFactory<V> quantityAttribute = attribute;
            return ItemFilters.buildComparisonFilter((PersistableItemFilter.Kind)comparisonKind, quantityAttribute, (Comparable)((IQuantity)value));
        }
        if (contentType instanceof RangeContentType) {
            ICanonicalAccessorFactory<V> rangeAttribute = attribute;
            IRange rangeValue = (IRange)value;
            return ItemFilters.matchRange((PersistableItemFilter.Kind)comparisonKind, rangeAttribute, (IRange)rangeValue);
        }
        return ItemFilters.buildEqualityFilter((PersistableItemFilter.Kind)comparisonKind, attribute, value);
    }

    private static boolean isAttributeFilter(Object element) {
        return element instanceof LeafNode && ((LeafNode)element).filter instanceof ItemFilters.AttributeFilter;
    }

    private static ItemFilters.AttributeFilter<?> asAttributeFilter(Object element) {
        return (ItemFilters.AttributeFilter)((LeafNode)element).filter;
    }

    private static <M> ItemFilters.AttributeFilter<M> asAttributeFilterM(Object element) {
        return FilterEditor.asAttributeFilter(element);
    }

    private static boolean isAttributeValue(Object element) {
        return element instanceof LeafNode && ((LeafNode)element).filter instanceof ItemFilters.AttributeValue;
    }

    private static ItemFilters.AttributeValue<?> asAttributeValue(Object element) {
        return (ItemFilters.AttributeValue)((LeafNode)element).filter;
    }

    private static boolean isRegexFilter(Object element) {
        return element instanceof LeafNode && (((LeafNode)element).filter instanceof ItemFilters.Matches || ((LeafNode)element).filter instanceof ItemFilters.Contains);
    }

    private static boolean isTypeMatches(Object element) {
        return element instanceof LeafNode && ((LeafNode)element).filter instanceof ItemFilters.TypeMatches;
    }

    private static ItemFilters.TypeMatches asTypeMatches(Object element) {
        return (ItemFilters.TypeMatches)((LeafNode)element).filter;
    }

    private static boolean isType(Object element) {
        return element instanceof LeafNode && ((LeafNode)element).filter instanceof ItemFilters.Type;
    }

    private static ItemFilters.Type asType(Object element) {
        return (ItemFilters.Type)((LeafNode)element).filter;
    }

    protected static String getAttributeName(ICanonicalAccessorFactory<?> attribute) {
        return attribute instanceof IAttribute ? ((IAttribute)attribute).getName() : attribute.getIdentifier();
    }

    protected static String getAttributeDescription(ICanonicalAccessorFactory<?> attribute) {
        return attribute instanceof IAttribute ? ((IAttribute)attribute).getDescription() : attribute.getIdentifier();
    }

    private static String getKindText(PersistableItemFilter.Kind kind) {
        switch (kind) {
            case TYPE: {
                return Messages.FilterEditor_KIND_IS;
            }
            case MATCHES: 
            case TYPE_MATCHES: {
                return Messages.FilterEditor_KIND_MATCHES;
            }
            case NOT_MATCHES: {
                return Messages.FilterEditor_KIND_NOT_MATCHES;
            }
            case CONTAINS: {
                return Messages.FilterEditor_KIND_CONTAINS;
            }
            case NOT_CONTAINS: {
                return Messages.FilterEditor_KIND_NOT_CONTAINS;
            }
            case IS_NULL: {
                return Messages.FilterEditor_KIND_IS_NULL;
            }
            case IS_NOT_NULL: {
                return Messages.FilterEditor_KIND_ISNT_NULL;
            }
            case EQUALS: {
                return "==";
            }
            case NOT_EQUALS: {
                return "!=";
            }
            case LESS: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case MORE: {
                return ">";
            }
            case MORE_OR_EQUAL: {
                return ">=";
            }
            case RANGE_INTERSECTS: {
                return Messages.FilterEditor_KIND_INTERSECTS;
            }
            case RANGE_CONTAINED: {
                return Messages.FilterEditor_KIND_IS_CONTAINED_IN;
            }
            case CENTER_CONTAINED: {
                return Messages.FilterEditor_KIND_HAS_CENTER_IN;
            }
            case EXISTS: {
                return Messages.FilterEditor_KIND_EXISTS;
            }
            case NOT_EXISTS: {
                return Messages.FilterEditor_KIND_DOESNT_EXIST;
            }
        }
        return Messages.FilterEditor_KIND_UNKNOWN;
    }

    private class AttributeEditingSupport
    extends EditingSupport {
        public AttributeEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return FilterEditor.isAttributeFilter(element);
        }

        protected CellEditor getCellEditor(Object ignored) {
            ComboBoxViewerCellEditor ce = new ComboBoxViewerCellEditor((Composite)FilterEditor.this.tree.getTree(), 65544);
            ce.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            if (FilterEditor.this.attributes == null) {
                FilterEditor.this.attributes = (Collection)FilterEditor.this.attributeSupplier.get();
            }
            ce.setInput((Object)FilterEditor.this.attributes.toArray());
            ce.setLabelProvider((IBaseLabelProvider)DelegatingLabelProvider.build(FilterEditor::getAttributeName));
            return ce;
        }

        protected Object getValue(Object element) {
            return FilterEditor.asAttributeFilter(element).getAttribute();
        }

        protected void setValue(Object element, Object value) {
            this.doSetValue((LeafNode)element, (IAttribute)value);
        }

        private <M> void doSetValue(LeafNode element, IAttribute<M> attr) {
            if (attr != null) {
                ContentType type = attr.getContentType();
                PersistableItemFilter.Kind[] allowedKinds = FilterEditor.this.getApplicableOperations(type);
                ItemFilters.AttributeFilter oldFilter = (ItemFilters.AttributeFilter)element.filter;
                PersistableItemFilter.Kind kind = oldFilter.getKind();
                if (!Arrays.asList(allowedKinds).contains(kind)) {
                    kind = allowedKinds[0];
                }
                Object value = null;
                if (type.equals(oldFilter.getAttribute().getContentType()) && oldFilter instanceof ItemFilters.AttributeValue) {
                    Object oldValue;
                    value = oldValue = ((ItemFilters.AttributeValue)oldFilter).getValue();
                }
                if (value == null) {
                    value = FilterEditor.this.attributeValueProvider.defaultValue(attr);
                }
                element.filter = FilterEditor.buildFilter(kind, attr, value);
                FilterEditor.this.tree.update((Object)element, null);
                FilterEditor.this.notifyListener();
            }
        }
    }

    public static interface AttributeValueProvider {
        public <V> V defaultValue(ICanonicalAccessorFactory<V> var1);
    }

    private static class CompositeNode
    extends FilterNode {
        List<FilterNode> children = new ArrayList<FilterNode>(3);
        boolean union;
        boolean negated;

        public CompositeNode(Stream<FilterNode> children, boolean union, boolean negated) {
            this.union = union;
            children.forEach(this.children::add);
            this.negated = negated;
        }

        @Override
        FilterNode copy() {
            return new CompositeNode(this.children.stream().map(FilterNode::copy), this.union, this.negated);
        }

        @Override
        IItemFilter doBuildFilter() {
            IItemFilter[] filters = new IItemFilter[this.children.size()];
            int i = 0;
            while (i < filters.length) {
                filters[i] = this.children.get(i).buildFilter();
                ++i;
            }
            IItemFilter compositeFilter = this.union ? ItemFilters.or((IItemFilter[])filters) : ItemFilters.and((IItemFilter[])filters);
            return this.negated ? ItemFilters.not((IItemFilter)compositeFilter) : compositeFilter;
        }
    }

    private static class EmptyNode
    extends FilterNode {
        private EmptyNode() {
        }

        @Override
        FilterNode copy() {
            return new EmptyNode();
        }

        @Override
        IItemFilter doBuildFilter() {
            return null;
        }
    }

    private static class FilterArrayContentProvider
    extends AbstractStructuredContentProvider
    implements ITreeContentProvider {
        private FilterArrayContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return element instanceof CompositeNode && !((CompositeNode)element).children.isEmpty();
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CompositeNode) {
                return ((CompositeNode)parentElement).children.toArray();
            }
            return new Object[0];
        }

        @Override
        public Object[] getElements(Object inputElement) {
            CompositeNode root = (CompositeNode)inputElement;
            if (root.children.isEmpty()) {
                return new Object[]{new EmptyNode()};
            }
            return this.getChildren(inputElement);
        }
    }

    private static abstract class FilterNode {
        private FilterNode() {
        }

        abstract FilterNode copy();

        abstract IItemFilter doBuildFilter();

        IItemFilter buildFilter() {
            return this.doBuildFilter();
        }
    }

    private static final class FilterNodeToolkit {
        private FilterNodeToolkit() {
            throw new IllegalAccessError("Do not implement!");
        }

        private static Map<FilterNode, CompositeNode> lookupParentRelations(CompositeNode root) {
            HashMap<FilterNode, CompositeNode> parentRelations = new HashMap<FilterNode, CompositeNode>();
            FilterNodeToolkit.addParentRelationsOfChildren(parentRelations, root);
            return parentRelations;
        }

        private static void addParentRelationsOfChildren(Map<FilterNode, CompositeNode> parentRelations, CompositeNode parent) {
            for (FilterNode child : parent.children) {
                parentRelations.put(child, parent);
                if (!(child instanceof CompositeNode)) continue;
                FilterNodeToolkit.addParentRelationsOfChildren(parentRelations, (CompositeNode)child);
            }
        }

        public static void deleteFilters(CompositeNode root, List<FilterNode> filters) {
            Map<FilterNode, CompositeNode> parentRelations = FilterNodeToolkit.lookupParentRelations(root);
            for (FilterNode filter : filters) {
                CompositeNode parent = parentRelations.get(filter);
                parent.children.remove(FilterNodeToolkit.getPosition(filter, parent));
            }
        }

        public static boolean unwrapFilter(CompositeNode root, CompositeNode filter) {
            CompositeNode parent = FilterNodeToolkit.getParent(filter, root);
            int position = FilterNodeToolkit.getPosition(filter, parent);
            parent.children.remove(position);
            for (FilterNode child : filter.children) {
                parent.children.add(position++, child);
            }
            return true;
        }

        public static CompositeNode wrapFilters(CompositeNode root, List<FilterNode> filters, boolean union) {
            FilterNode first = filters.get(0);
            CompositeNode parent = FilterNodeToolkit.getParent(first, root);
            int position = FilterNodeToolkit.getPosition(first, parent);
            CompositeNode wrapper = new CompositeNode(filters.stream(), union, false);
            int i = filters.size();
            while (i > 0) {
                parent.children.remove(position);
                --i;
            }
            parent.children.add(position, wrapper);
            return wrapper;
        }

        public static int getPosition(FilterNode node, CompositeNode parent) {
            return parent.children.indexOf(node);
        }

        public static CompositeNode getParent(FilterNode node, CompositeNode root) {
            for (FilterNode child : root.children) {
                CompositeNode result;
                if (child == node) {
                    return root;
                }
                if (!(child instanceof CompositeNode) || (result = FilterNodeToolkit.getParent(node, (CompositeNode)child)) == null) continue;
                return result;
            }
            return null;
        }
    }

    private static class LeafNode
    extends FilterNode {
        IItemFilter filter;

        public LeafNode(IItemFilter filter) {
            this.filter = filter;
        }

        @Override
        FilterNode copy() {
            return new LeafNode(this.filter);
        }

        @Override
        IItemFilter doBuildFilter() {
            return this.filter;
        }
    }

    private static class NameLabelProvider
    extends ColumnLabelProvider {
        private final Function<String, Color> typeColorProvider;

        NameLabelProvider(Function<String, Color> typeColorProvider) {
            this.typeColorProvider = typeColorProvider;
        }

        public String getText(Object element) {
            if (element instanceof EmptyNode) {
                return Messages.FilterEditor_LABEL_EMPTY;
            }
            if (element instanceof CompositeNode) {
                CompositeNode filter = (CompositeNode)element;
                if (filter.union) {
                    return filter.negated ? Messages.FilterEditor_LABEL_NAME_NOT_OR : Messages.FilterEditor_LABEL_NAME_OR;
                }
                return filter.negated ? Messages.FilterEditor_LABEL_NAME_NOT_AND : Messages.FilterEditor_LABEL_NAME_AND;
            }
            return this.getTextForFilter(((LeafNode)element).filter);
        }

        private String getTextForFilter(IItemFilter filter) {
            if (filter instanceof ItemFilters.Not) {
                return this.getTextForFilter(((ItemFilters.Not)filter).getFilter());
            }
            if (filter instanceof ItemFilters.AttributeFilter) {
                ItemFilters.AttributeFilter af = (ItemFilters.AttributeFilter)filter;
                return FilterEditor.getAttributeName(af.getAttribute());
            }
            if (filter instanceof ItemFilters.Type) {
                return Messages.FilterEditor_LABEL_NAME_TYPE;
            }
            if (filter instanceof ItemFilters.TypeMatches) {
                return Messages.FilterEditor_LABEL_NAME_TYPE;
            }
            return Messages.FilterEditor_LABEL_NAME_UNKNOWN_FILTER;
        }

        public Image getImage(Object element) {
            if (element instanceof EmptyNode) {
                return null;
            }
            if (element instanceof CompositeNode) {
                return UIPlugin.getDefault().getImage(((CompositeNode)element).union ? "add.gif" : "other.gif");
            }
            return this.getImageForFilter(((LeafNode)element).filter);
        }

        private Image getImageForFilter(IItemFilter element) {
            if (element instanceof ItemFilters.Not) {
                return this.getImageForFilter(((ItemFilters.Not)element).getFilter());
            }
            if (element instanceof ItemFilters.AttributeFilter) {
                return this.getImageForType(((ItemFilters.AttributeFilter)element).getAttribute().getContentType().getIdentifier());
            }
            if (element instanceof ItemFilters.Type) {
                String typeId = ((ItemFilters.Type)element).getTypeId();
                Image icon = TypeAppearance.getImage(typeId);
                if (icon == null) {
                    return SWTColorToolkit.getColorThumbnail(SWTColorToolkit.asRGB(this.typeColorProvider.apply(typeId)));
                }
                return icon;
            }
            if (element instanceof ItemFilters.TypeMatches) {
                return UIPlugin.getDefault().getImage("regex.png");
            }
            return null;
        }

        private Image getImageForType(String typeId) {
            Image icon = TypeAppearance.getImage(typeId);
            return icon == null ? UIPlugin.getDefault().getImage("property_obj.gif") : icon;
        }

        public org.eclipse.swt.graphics.Color getForeground(Object element) {
            if (element instanceof EmptyNode) {
                return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
            }
            return null;
        }

        public String getToolTipText(Object element) {
            if (element instanceof LeafNode && ((LeafNode)element).filter instanceof ItemFilters.AttributeFilter) {
                ItemFilters.AttributeFilter af = (ItemFilters.AttributeFilter)((LeafNode)element).filter;
                return FilterEditor.getAttributeDescription(af.getAttribute());
            }
            return super.getToolTipText(element);
        }
    }

    static class OperationCellEditor
    extends ComboBoxViewerCellEditor {
        private final ControlDecoration errorDecorator;
        private Object element;

        public OperationCellEditor(Composite parent, int style, Object element) {
            super(parent, style);
            this.element = element;
            this.errorDecorator = ControlDecorationToolkit.createErrorDecorator(this.getViewer().getControl());
            this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    this.validate();
                }
            });
        }

        public void activate() {
            super.activate();
            this.validate();
        }

        protected void doSetValue(Object value) {
            super.doSetValue(value);
            this.validate(value);
        }

        private void validate() {
            ISelection selection = this.getViewer().getSelection();
            if (selection instanceof StructuredSelection) {
                this.validate(((StructuredSelection)this.getViewer().getSelection()).getFirstElement());
            }
        }

        private void validate(Object value) {
            this.errorDecorator.hide();
            if (REGEX_OPERATIONS.contains(value) && FilterEditor.isAttributeValue(this.element)) {
                String str = FilterEditor.asAttributeValue(this.element).getValue().toString();
                FilterEditor.validateRegex(str, this.errorDecorator);
            }
        }
    }

    private class OperationEditingSupport
    extends EditingSupport {
        public OperationEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return FilterEditor.isAttributeFilter(element);
        }

        protected CellEditor getCellEditor(Object element) {
            ContentType ct = this.getAttribute(element).getContentType();
            OperationCellEditor ce = new OperationCellEditor((Composite)FilterEditor.this.tree.getTree(), 65544, element);
            ce.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            ce.setInput(FilterEditor.this.getApplicableOperations(ct));
            ce.setLabelProvider((IBaseLabelProvider)DelegatingLabelProvider.build(FilterEditor::access$2));
            return ce;
        }

        private ICanonicalAccessorFactory<?> getAttribute(Object element) {
            return ((ItemFilters.AttributeFilter)((LeafNode)element).filter).getAttribute();
        }

        protected PersistableItemFilter.Kind getValue(Object element) {
            if (FilterEditor.isAttributeFilter(element)) {
                return FilterEditor.asAttributeFilter(element).getKind();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                this.doSetValue((LeafNode)element, FilterEditor.asAttributeFilter(element), (PersistableItemFilter.Kind)value);
            }
        }

        private <M> void doSetValue(LeafNode element, ItemFilters.AttributeFilter<M> current, PersistableItemFilter.Kind newKind) {
            Object value = null;
            value = current instanceof ItemFilters.AttributeValue ? ((ItemFilters.AttributeValue)current).getValue() : FilterEditor.this.attributeValueProvider.defaultValue(current.getAttribute());
            element.filter = FilterEditor.buildFilter(newKind, current.getAttribute(), value);
            FilterEditor.this.tree.update((Object)element, null);
            FilterEditor.this.notifyListener();
        }
    }

    private static class OperationLabelProvider
    extends ColumnLabelProvider {
        private OperationLabelProvider() {
        }

        public String getText(Object element) {
            if (FilterEditor.isAttributeFilter(element)) {
                return FilterEditor.getKindText(FilterEditor.asAttributeFilter(element).getKind());
            }
            if (FilterEditor.isTypeMatches(element)) {
                return FilterEditor.getKindText(PersistableItemFilter.Kind.TYPE_MATCHES);
            }
            if (FilterEditor.isType(element)) {
                return FilterEditor.getKindText(PersistableItemFilter.Kind.TYPE);
            }
            return "";
        }
    }

    private static class RegexCellEditor
    extends TextCellEditor {
        private final ControlDecoration errorDecorator;

        RegexCellEditor(Composite parent) {
            super(parent);
            this.errorDecorator = ControlDecorationToolkit.createErrorDecorator((Control)this.text);
        }

        public void activate() {
            super.activate();
            this.validate();
        }

        protected void editOccured(ModifyEvent e) {
            this.validate();
        }

        private void validate() {
            String str = this.text.getText();
            this.errorDecorator.hide();
            FilterEditor.validateRegex(str, this.errorDecorator);
        }
    }

    private class ValueEditingSupport
    extends EditingSupport {
        public ValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return FilterEditor.isAttributeValue(element) || FilterEditor.isTypeMatches(element) || FilterEditor.isType(element);
        }

        protected CellEditor getCellEditor(Object element) {
            if (FilterEditor.isAttributeValue(element)) {
                ContentType contentType = FilterEditor.asAttributeValue(element).getAttribute().getContentType();
                if (contentType.equals(UnitLookup.FLAG)) {
                    return new CheckboxCellEditor();
                }
                if (contentType instanceof KindOfQuantity) {
                    return CommonCellEditors.create((Composite)FilterEditor.this.tree.getTree(), (KindOfQuantity)contentType);
                }
                if (contentType instanceof RangeContentType) {
                    return CommonCellEditors.create((Composite)FilterEditor.this.tree.getTree(), (RangeContentType)contentType);
                }
                if (FilterEditor.isRegexFilter(element)) {
                    return new RegexCellEditor((Composite)FilterEditor.this.tree.getTree());
                }
                if (contentType.getPersister() != null) {
                    return CommonCellEditors.create((Composite)FilterEditor.this.tree.getTree(), contentType.getPersister());
                }
            } else {
                if (FilterEditor.isTypeMatches(element)) {
                    return new RegexCellEditor((Composite)FilterEditor.this.tree.getTree());
                }
                if (FilterEditor.isType(element)) {
                    return new TextCellEditor((Composite)FilterEditor.this.tree.getTree());
                }
            }
            return null;
        }

        protected Object getValue(Object element) {
            if (FilterEditor.isAttributeValue(element)) {
                return FilterEditor.asAttributeValue(element).getValue();
            }
            if (FilterEditor.isTypeMatches(element)) {
                return FilterEditor.asTypeMatches(element).getTypeMatch();
            }
            if (FilterEditor.isType(element)) {
                return FilterEditor.asType(element).getTypeId();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            this.doSetValue((LeafNode)element, value);
        }

        private <M> void doSetValue(LeafNode element, M value) {
            if (value != null) {
                if (FilterEditor.isAttributeValue(element)) {
                    ItemFilters.AttributeValue currentFilter = (ItemFilters.AttributeValue)element.filter;
                    element.filter = FilterEditor.buildFilter(currentFilter.getKind(), currentFilter.getAttribute(), value);
                } else if (FilterEditor.isTypeMatches(element)) {
                    element.filter = ItemFilters.typeMatches((String)((String)value));
                } else if (FilterEditor.isType(element)) {
                    element.filter = ItemFilters.type((String)((String)value));
                }
                FilterEditor.this.tree.update((Object)element, null);
                FilterEditor.this.notifyListener();
            }
        }
    }

    private static class ValueLabelProvider
    extends TypedLabelProvider<LeafNode> {
        public ValueLabelProvider() {
            super(LeafNode.class);
        }

        @Override
        protected String getTextTyped(LeafNode element) {
            if (element.filter instanceof ItemFilters.AttributeFilter) {
                return this.getValueText((ItemFilters.AttributeFilter)element.filter);
            }
            if (element.filter instanceof ItemFilters.Type) {
                return this.getTypeName(((ItemFilters.Type)element.filter).getTypeId());
            }
            if (element.filter instanceof ItemFilters.TypeMatches) {
                return ((ItemFilters.TypeMatches)element.filter).getTypeMatch();
            }
            return Messages.FilterEditor_LABEL_VALUE_UNKNOWN;
        }

        protected <V> String getValueText(ItemFilters.AttributeFilter<V> filter) {
            if (filter instanceof ItemFilters.AttributeValue) {
                return filter.getAttribute().getContentType().getDefaultFormatter().format(((ItemFilters.AttributeValue)filter).getValue());
            }
            return "";
        }

        protected <V> String getValueTooltipText(ItemFilters.AttributeValue<V> value) {
            return value.getAttribute().getContentType().getFormatter("exact").format(value.getValue());
        }

        protected String getTypeName(String typeID) {
            return typeID;
        }

        @Override
        public Font getFont(Object element) {
            ItemFilters.AttributeValue value;
            if (element instanceof LeafNode && ((LeafNode)element).filter instanceof ItemFilters.AttributeValue && (value = (ItemFilters.AttributeValue)((LeafNode)element).filter).getValue() == null) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            return super.getFont(element);
        }

        @Override
        public String getToolTipText(Object element) {
            if (element instanceof LeafNode && ((LeafNode)element).filter instanceof ItemFilters.AttributeValue) {
                ItemFilters.AttributeValue value = (ItemFilters.AttributeValue)((LeafNode)element).filter;
                return this.getValueTooltipText(value);
            }
            return super.getToolTipText(element);
        }
    }
}

