/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TransferData;

public class DndToolkit {
    public static <T> DragSourceListener createLocalDragSource(AbstractTreeViewer viewer, Consumer<ITreeSelection> onMove) {
        return DndToolkit.createLocalDragSource(() -> ((AbstractTreeViewer)viewer).getSelection(), (ISelection selection) -> onMove.accept((ITreeSelection)selection));
    }

    public static <T> DragSourceListener createLocalDragSource(final StructuredViewer viewer, final Predicate<List<T>> isSelectionDraggable, Consumer<List<T>> onMove) {
        return DndToolkit.createLocalDragSource(new Supplier<ISelection>(){

            @Override
            public ISelection get() {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                return isSelectionDraggable.test(selection.toList()) ? selection : null;
            }
        }, onMove == null ? null : selection -> onMove.accept(((IStructuredSelection)selection).toList()));
    }

    public static DragSourceListener createLocalDragSource(final Supplier<ISelection> selectionSupplier, final Consumer<ISelection> onMove) {
        return new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                ISelection selection = (ISelection)selectionSupplier.get();
                if (selection != null) {
                    LocalSelectionTransfer.getTransfer().setSelection(selection);
                    event.doit = true;
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (onMove != null && event.doit && event.detail == 2) {
                    onMove.accept(LocalSelectionTransfer.getTransfer().getSelection());
                }
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        };
    }

    public static <T, U> ViewerDropAdapter createLocalDropListTarget(Viewer viewer, Class<T> targetType, final Class<U> srcType, final IDropAction<List<? extends U>, T> action, final IDropValidator<List<? extends U>, T> validator) {
        return DndToolkit.createLocalDropTarget(viewer, targetType, new IDropAction<ISelection, T>(){

            @Override
            public boolean drop(ISelection src, T ontarget, int operation, int location) {
                return action.drop(((IStructuredSelection)src).toList(), ontarget, operation, location);
            }
        }, new IDropValidator<ISelection, T>(){

            @Override
            public int getOperation(ISelection src, T onTarget, int operation) {
                IStructuredSelection sel;
                if (src instanceof IStructuredSelection && (sel = (IStructuredSelection)src).toList().stream().allMatch(srcType::isInstance)) {
                    return validator == null ? operation : validator.getOperation(sel.toList(), onTarget, operation);
                }
                return 0;
            }
        });
    }

    public static <T> ViewerDropAdapter createLocalDropTarget(Viewer viewer, final Class<T> targetType, final IDropAction<ISelection, T> action, final IDropValidator<ISelection, T> validator) {
        return new ViewerDropAdapter(viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                int overrideOperation;
                ISelection selection;
                if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && (target == null || targetType.isInstance(target)) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) != null && !selection.isEmpty() && (overrideOperation = validator.getOperation(selection, targetType.cast(target), operation)) != 0) {
                    if (overrideOperation != operation) {
                        this.overrideOperation(overrideOperation);
                    }
                    return true;
                }
                return false;
            }

            public boolean performDrop(Object data) {
                return action.drop((ISelection)data, targetType.cast(this.getCurrentTarget()), this.getCurrentOperation(), this.getCurrentLocation());
            }
        };
    }

    public static interface IDropAction<T, U> {
        public boolean drop(T var1, U var2, int var3, int var4);
    }

    public static interface IDropValidator<T, U> {
        public int getOperation(T var1, U var2, int var3);
    }
}

