/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import java.util.GregorianCalendar;
import java.util.function.LongUnaryOperator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class DateTimeChooser
extends Composite {
    private final DateTime m_dateWidget;
    private final DateTime m_timeWidget;
    private LongUnaryOperator m_timestampConstraint;

    public DateTimeChooser(Composite parent, int style) {
        super(parent, style);
        FillLayout layout = new FillLayout();
        layout.type = 256;
        this.setLayout((Layout)layout);
        SelectionListener selectionListener = this.createSelectionListener();
        this.m_dateWidget = new DateTime((Composite)this, 65572);
        this.m_dateWidget.addSelectionListener(selectionListener);
        this.m_timeWidget = new DateTime((Composite)this, 0x10000080);
        this.m_timeWidget.addSelectionListener(selectionListener);
    }

    public void setEnabled(boolean enabled) {
        this.m_dateWidget.setEnabled(enabled);
        this.m_timeWidget.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private SelectionListener createSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeChooser.this.constrainValue();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DateTimeChooser.this.constrainValue();
            }
        };
    }

    private void constrainValue() {
        long constrainedTime;
        long currentTime;
        if (this.m_timestampConstraint != null && (currentTime = this.getTimestamp()) != (constrainedTime = this.m_timestampConstraint.applyAsLong(currentTime))) {
            this.setTimestamp(constrainedTime);
        }
    }

    public long getTimestamp() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(this.m_dateWidget.getYear(), this.m_dateWidget.getMonth(), this.m_dateWidget.getDay(), this.m_timeWidget.getHours(), this.m_timeWidget.getMinutes(), this.m_timeWidget.getSeconds());
        return calendar.getTimeInMillis();
    }

    public void setTimestamp(long time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(time);
        this.m_dateWidget.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        this.m_timeWidget.setTime(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public void setConstraint(LongUnaryOperator timestampConstraint) {
        this.m_timestampConstraint = timestampConstraint;
    }
}

