/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.ui.misc.DisplayToolkit;
import com.oracle.jmc.ui.misc.Messages;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CompositeToolkit {
    public static ScrolledComposite createVerticalScrollComposite(Composite parent) {
        final ScrolledComposite scrolled = new ScrolledComposite(parent, 512);
        scrolled.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Control content = scrolled.getContent();
                if (DisplayToolkit.isSafe((Widget)content)) {
                    scrolled.setMinHeight(content.computeSize((int)scrolled.getClientArea().width, (int)-1).y);
                }
            }
        });
        scrolled.setExpandVertical(true);
        scrolled.setExpandHorizontal(true);
        return scrolled;
    }

    public static FormText createInfoFormText(Composite parent) {
        Display display = parent.getDisplay();
        FormText formText = new FormText(parent, 64);
        formText.marginHeight = 5;
        formText.marginWidth = 5;
        formText.setForeground(display.getSystemColor(28));
        formText.setBackground(display.getSystemColor(29));
        return formText;
    }

    public static ProgressIndicator createWaitIndicator(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new GridLayout());
        Composite centerComposite = toolkit.createComposite(parent, 0);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        centerComposite.setLayout((Layout)new GridLayout());
        ProgressIndicator progressIndicator = new ProgressIndicator(centerComposite);
        progressIndicator.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        toolkit.adapt((Composite)progressIndicator);
        progressIndicator.beginAnimatedTask();
        Label label = toolkit.createLabel(centerComposite, Messages.ProgressComposite_PLEASE_WAIT);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        return progressIndicator;
    }

    public static Section createSection(Composite parent, FormToolkit toolkit, String text) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(text);
        toolkit.adapt((Composite)section);
        return section;
    }
}

