/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import java.util.Arrays;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

public class ClipboardManager {
    public static Transfer getClipboardLocalTransfer() {
        return LocalObjectTransfer.INSTANCE;
    }

    public static void setClipboardContents(Object[] data, Transfer[] dataTypes) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            clipboard.setContents(data, dataTypes);
        }
        finally {
            clipboard.dispose();
        }
    }

    public static Object getClipboardContents(Transfer dataType) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            Object object = clipboard.getContents(dataType);
            return object;
        }
        finally {
            clipboard.dispose();
        }
    }

    private static class LocalObjectTransfer
    extends ByteArrayTransfer {
        private static final LocalObjectTransfer INSTANCE = new LocalObjectTransfer();
        private static final String TYPE_NAME = "local-object-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)INSTANCE)).hashCode();
        private static final int TYPE_ID = LocalObjectTransfer.registerType((String)TYPE_NAME);
        private static final byte[] TYPE_NAME_BYTES = TYPE_NAME.getBytes();
        private Object obj;

        private LocalObjectTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPE_ID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        protected void javaToNative(Object object, TransferData transferData) {
            super.javaToNative((Object)TYPE_NAME_BYTES, transferData);
            this.obj = object;
        }

        protected Object nativeToJava(TransferData transferData) {
            Object o = super.nativeToJava(transferData);
            if (o instanceof byte[] && Arrays.equals((byte[])o, TYPE_NAME_BYTES)) {
                return this.obj;
            }
            return null;
        }
    }
}

