/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.ui.misc;

import com.oracle.jmc.common.internal.util.Environment;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class AwtCanvas {
    private ImageData imageDataSWT;
    private BufferedImage imageAWT;
    private static final double X_SCALE = (double)Display.getCurrent().getDPI().x / Environment.getNormalDPI();
    private static final double Y_SCALE = (double)Display.getCurrent().getDPI().y / Environment.getNormalDPI();

    public boolean hasImage(int width, int height) {
        return this.imageDataSWT != null && this.imageDataSWT.width == width && this.imageDataSWT.height == height;
    }

    public Graphics2D getGraphics(int width, int height) {
        if (this.imageDataSWT == null || this.imageDataSWT.width != width || this.imageDataSWT.height != height) {
            this.imageAWT = new BufferedImage(width, height, 5);
            PaletteData vpPalette = new PaletteData(255, 65280, 0xFF0000);
            int scanlinePad = width * 3;
            byte[] byteData = ((DataBufferByte)this.imageAWT.getRaster().getDataBuffer()).getData();
            this.imageDataSWT = new ImageData(width, height, 24, vpPalette, scanlinePad, byteData);
            Graphics2D graphicsAWT = this.imageAWT.createGraphics();
            this.fixDPI(graphicsAWT);
            return graphicsAWT;
        }
        Graphics2D graphicsAWT = this.imageAWT.createGraphics();
        graphicsAWT.clearRect(0, 0, width, height);
        this.fixDPI(graphicsAWT);
        return graphicsAWT;
    }

    private void fixDPI(Graphics2D ctx) {
        AffineTransform defaultTransform = ctx.getDeviceConfiguration().getDefaultTransform();
        defaultTransform.scale(X_SCALE, Y_SCALE);
        ctx.setTransform(defaultTransform);
    }

    public void paint(PaintEvent e, int x, int y) {
        try {
            Image img = new Image((Device)e.display, this.imageDataSWT);
            e.gc.drawImage(img, x, y);
            img.dispose();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

